/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLine;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgMethod\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgMethodJsSourceExpander {

    /**
     * Ń\bhWJ܂B
     * 
     * @param cgMethod
     *            ΏۂƂȂ郁\bhB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     */
    public void transformMethod(final BlancoCgClass cgClass,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (BlancoStringUtil.null2Blank(cgMethod.getName()).length() == 0) {
            throw new IllegalArgumentException("\bh̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (cgMethod.getReturn() == null) {
            // ͂肦܂Bvoid̏ꍇɂnullw肳̂łB
        }

        // st^B
        argSourceLines.add("");

        prepareExpand(cgClass, cgMethod, argSourceFile);

        // 񂪈ꎮ̂ŁA\[XR[h̎ۂ̓WJs܂B

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocJsSourceExpander().transformLangDoc(cgMethod
                .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgMethod, argSourceLines);

        // \bh̖{̕WJB
        expandMethodBody(cgClass, cgMethod, argSourceFile, argSourceLines);
    }

    /**
     * NXɊ܂܂ static ȃtB[hWJ܂B
     * 
     * ݂ o^Ń\[XR[hWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    public void transformStaticFieldList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (cgClass.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        for (int index = 0; index < cgClass.getFieldList().size(); index++) {
            final Object objField = cgClass.getFieldList().get(index);
            if (objField instanceof BlancoCgField == false) {
                throw new IllegalArgumentException("tB[h̃XgɃtB[hȊǑ^["
                        + objField.getClass().getName() + "]̒l^܂B");
            }
            final BlancoCgField cgField = (BlancoCgField) objField;

            if (cgField.getStatic()) {
                // ł̓NX̃tB[h (staticȃtB[h) ݂̂WJ܂B
                new BlancoCgFieldJsSourceExpander().transformField(cgClass,
                        cgField, argSourceFile, argSourceLines);
            }
        }
    }

    /**
     * \[XR[hWJɐ旧AKvȏ̎Ws܂B
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceFile
     *            \[Xt@CB
     */
    private void prepareExpand(final BlancoCgClass cgClass,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile) {
        // ŏɃ\bhLangDocɓWJB
        if (cgMethod.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgMethod.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgMethod.getLangDoc().getParameterList() == null) {
            cgMethod.getLangDoc().setParameterList(new ArrayList());
        }
        if (cgMethod.getLangDoc().getThrowList() == null) {
            cgMethod.getLangDoc().setThrowList(new ArrayList());
        }
        if (cgMethod.getLangDoc().getTitle() == null) {
            cgMethod.getLangDoc().setTitle(cgMethod.getDescription());
        }

        if (cgMethod.getConstructor()) {
            // t@NV̂̂LangDocɓWJ܂B
            cgMethod.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "class", null, cgClass.getDescription()));

            cgMethod.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "constructor", null, ""));
        } else {
            cgMethod.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "addon", null, ""));
        }

        if (BlancoStringUtil.null2Blank(cgMethod.getAccess()).equals("private")) {
            cgMethod.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "private", null, ""));
        }

        for (int indexParameter = 0; indexParameter < cgMethod
                .getParameterList().size(); indexParameter++) {
            final Object objParameter = cgMethod.getParameterList().get(
                    indexParameter);
            if (objParameter instanceof BlancoCgParameter == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^ɕsȌ^[" + objParameter.getClass().getName()
                        + "]^܂B");
            }
            final BlancoCgParameter cgParameter = (BlancoCgParameter) objParameter;

            // importɌ^ǉB
            argSourceFile.getImportList().add(cgParameter.getType().getName());

            // hLgɃp[^ǉB
            cgMethod.getLangDoc().getParameterList().add(cgParameter);
        }

        if (cgMethod.getReturn() != null) {
            // importɌ^ǉB
            argSourceFile.getImportList().add(
                    cgMethod.getReturn().getType().getName());

            // hLgreturnǉB
            cgMethod.getLangDoc().setReturn(cgMethod.getReturn());
        }

        // OɂLangDoc\̂ɓWJ
        for (int index = 0; index < cgMethod.getThrowList().size(); index++) {
            final Object objException = cgMethod.getThrowList().get(index);
            if (objException instanceof BlancoCgException == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]throwsBlancoCgExceptionȊǑ^["
                        + objException.getClass().getName() + "]^܂B");
            }
            final BlancoCgException cgException = (BlancoCgException) objException;

            // importɌ^ǉB
            argSourceFile.getImportList().add(cgException.getType().getName());

            // hLgɗOǉB
            cgMethod.getLangDoc().getThrowList().add(cgException);
        }
    }

    /**
     * \bh̖{̕WJ܂B
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceLines
     *            \[XR[hB
     * @param argIsInterface
     *            C^tF[XƂēWJ邩ǂB
     */
    private void expandMethodBody(final BlancoCgClass cgClass,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        final StringBuffer buf = new StringBuffer();

        if (cgMethod.getConstructor()) {
            // RXgN^̏ꍇɂ functionn܂܂B
            buf.append("function " + cgClass.getName());
        } else {
            // ʏ̃\bh̏ꍇɂ́ARXgN^ prototypeւfunction̒ǉƂȂ܂B
            buf.append(cgClass.getName() + ".prototype." + cgMethod.getName()
                    + " = function");
        }

        // JavaScriptɂ̓ANZXtÔ݂̂͑܂B
        // JSDoc̋LqƂăANZX\Ă܂B

        // JavaScriptł͌ƂĂ͖߂l͏o͂܂BJSDoc̋LqƂĂ̂ݕ\܂B

        buf.append("(");
        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = (BlancoCgParameter) cgMethod
                    .getParameterList().get(index);
            if (cgParameter.getType() == null) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^[" + cgParameter.getName()
                        + "]Ɍ^null^܂B");
            }

            if (index != 0) {
                buf.append(", ");
            }

            // JavaScriptłfinalC͖łB

            buf.append("/* "
                    + BlancoCgTypeJsSourceExpander.toTypeString(cgParameter
                            .getType()) + " */");
            buf.append(" ");
            buf.append(cgParameter.getName());
        }
        buf.append(")");

        // OX[WJJavaScriptɂ݂͑܂B

        if (cgMethod.getAbstract()) {
            // ۃ\bh܂̓C^tF[X̏ꍇɂ́A\bh̖{̂WJ܂B
            buf.append(";");
            argSourceLines.add(buf.toString());
        } else {
            // \bhubN̊JnB
            buf.append(" {");

            // łAsmB
            argSourceLines.add(buf.toString());

            // `FbN̎s܂B
            argSourceLines.add("/* p[^̐A^`FbNs܂B */");
            argSourceLines.add("if (arguments.length !== "
                    + cgMethod.getParameterList().size() + ") {");
            argSourceLines
                    .add("throw new Error(\"[IllegalArgumentException]: "
                            + cgClass.getName()
                            + "."
                            + cgMethod.getName()
                            + " ̃p[^["
                            + cgMethod.getParameterList().size()
                            + "]łKv܂Bۂɂ[\" + arguments.length +  \"]̃p[^𔺂ČĂяo܂B\");");
            argSourceLines.add("}");

            for (int indexParameter = 0; indexParameter < cgMethod
                    .getParameterList().size(); indexParameter++) {
                final BlancoCgParameter cgParameter = (BlancoCgParameter) cgMethod
                        .getParameterList().get(indexParameter);
                if (BlancoCgTypeJsSourceExpander
                        .isLanguageReservedKeyword(BlancoStringUtil
                                .null2Blank(cgParameter.getType().getName()))) {
                    argSourceLines.add("if (typeof(" + cgParameter.getName()
                            + ") != \"" + cgParameter.getType().getName()
                            + "\") {");
                } else {
                    argSourceLines.add("if (" + cgParameter.getName()
                            + " instanceof " + cgParameter.getType().getName()
                            + " == false) {");
                }
                argSourceLines
                        .add("throw new Error(\"[IllegalArgumentException]: "
                                + cgClass.getName() + "." + cgMethod.getName()
                                + " " + (indexParameter + 1) + "Ԗڂ̃p[^["
                                + cgParameter.getType().getName()
                                + "]^łȂĂ͂Ȃ܂Bۂɂ[\" + typeof("
                                + cgParameter.getName()
                                + ") + \"]^^܂B\");");
                argSourceLines.add("}");
            }

            argSourceLines.add("");

            if (cgMethod.getConstructor()) {
                // RXgN^ł̂ŃtB[hWJ܂B
                // JavaScript̏ꍇɂ́ANXɃtB[hWĴł͂ȂRXgN^ɃtB[hWJ݂܂B
                expandFieldList(cgClass, argSourceFile, argSourceLines);
            }

            // eNX\bhs@\̓WJB
            if (BlancoStringUtil.null2Blank(cgMethod.getSuperclassInvocation())
                    .length() > 0) {
                // super() Ȃǂ܂܂܂B
                argSourceLines.add(cgMethod.getSuperclassInvocation() + ";");
            }

            // sWJ܂B
            expandLineList(cgMethod, argSourceLines);

            // \bhubN̏IB
            if (cgMethod.getConstructor()) {
                // NX錾ł͍ŌɃZ~Rt^܂B
                argSourceLines.add("}");
            } else {
                // JavaScriptł͍ŌɃZ~Rt^܂B
                argSourceLines.add("};");
            }
        }
    }

    /**
     * NXɊ܂܂eX̃tB[hWJ܂B
     * 
     * ݂ o^Ń\[XR[hWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandFieldList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (cgClass.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        for (int index = 0; index < cgClass.getFieldList().size(); index++) {
            final Object objField = cgClass.getFieldList().get(index);
            if (objField instanceof BlancoCgField == false) {
                throw new IllegalArgumentException("tB[h̃XgɃtB[hȊǑ^["
                        + objField.getClass().getName() + "]̒l^܂B");
            }
            final BlancoCgField cgField = (BlancoCgField) objField;

            if (cgField.getStatic() == false) {
                // RXgN^̒ŁAstaticł͂ȂtB[hWJ܂B
                new BlancoCgFieldJsSourceExpander().transformField(cgClass,
                        cgField, argSourceFile, argSourceLines);
            }
        }
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgMethod cgMethod,
            final List argSourceLines) {
        if (cgMethod.getOverride()) {
            // JavaScriptł override\͌_ł̓T|[gOłB
            throw new IllegalArgumentException(
                    "o[W blancoCg JavaScript̍ۂɂ̓I[o[Ch\T|[g܂B");
            // argSourceLines.add("@Override");
        }

        for (int index = 0; index < cgMethod.getAnnotationList().size(); index++) {
            final Object objAnnotation = cgMethod.getAnnotationList()
                    .get(index);
            if (objAnnotation instanceof String == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]Annotationjava.lang.StringȊǑ^["
                        + objAnnotation.getClass().getName() + "]^܂B");
            }

            final String strAnnotation = (String) objAnnotation;
            throw new IllegalArgumentException(
                    "o[W blancoCg JavaScript̍ۂɂ̓Ame[VT|[g܂B"
                            + strAnnotation);
            // JavaScriptAnnotation͕słB
            // argSourceLines.add("@" + strAnnotation);
        }
    }

    /**
     * sWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            o͍sXgB
     */
    private void expandLineList(final BlancoCgMethod cgMethod,
            final List argSourceLines) {
        for (int indexLine = 0; indexLine < cgMethod.getLineList().size(); indexLine++) {
            final BlancoCgLine cgLine = (BlancoCgLine) cgMethod.getLineList()
                    .get(indexLine);
            if (BlancoStringUtil.null2Blank(cgLine.getDescription()).length() > 0) {
                argSourceLines.add("// " + cgLine.getDescription());
            }
            argSourceLines.add(cgLine.getValue());
        }
    }
}
