/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.constants.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.constants.BlancoConstantsMeta2Xml;
import blanco.constants.BlancoConstantsXml2JavaClass;

/**
 * 萔`(XLS)Java\[XR[hAnt^XNłB
 * 
 * ̃NX́AblancoɂĎꂽAAnt^XNۃNXpĂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoConstantsTask extends AbstractBlancoConstantsTask {
    /**
     * e|fBNgł̃[NTufBNgB
     */
    private static final String TARGET_DIRECTORY = "/constants";

    /**
     * 萔`(XLS)Java\[XR[hAnt^XÑGg|CgłB
     * 
     * ̃NX́AblancoɂĎꂽAAnt^XNۃNXĂяo܂B<br>
     * ۃNXŊe̓`FbNIԂŁÃ\bh͌Ăяo܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + TARGET_DIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoConstantsMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + TARGET_DIRECTORY);

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(getTmpdir() + TARGET_DIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoConstantsXml2JavaClass().process(fileMeta2[index],
                        new File(getTargetdir()));
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
