/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * blancoCodeGenerator̎R[h\郉bp[NXB
 * 
 * @deprecated ̃NX̗p͐܂B݊̂߂ɎcĂ邾łB
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class Receiver extends Statement {
    private String _name = "";

    private Type _staticClass = null;

    private Call _call = null;

    public Receiver(String name) {
        _name = name;
    }

    public Receiver(String name, String methodName) {
        this(name);
        call(methodName);
    }

    public Receiver(Value value) {
        this(value.getName());
    }

    public Receiver(Value value, String methodName) {
        this(value);
        call(methodName);
    }

    public Receiver(Class staticClass, String name) {
        this(new Type(staticClass), name);
    }

    public Receiver(Type staticClass, String name) {
        _staticClass = staticClass;
        _name = name;
        addUsingType(staticClass);
    }

    public Call call(String methodName) {
        _call = new Call(methodName);
        addSubStatement(_call);
        return _call;
    }

    public Call getCalledMethod() {
        return _call;
    }

    public String getStatementString() {
        StringBuffer sb = new StringBuffer();
        if (_staticClass != null) {
            sb.append(_staticClass.getName());
            sb.append(".");
        }
        sb.append(_name);
        if (_call != null) {
            sb.append(".");
            sb.append(_call.toString());
        }
        return sb.toString();
    }
}
