/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author IGA Tosiki
 */
public class PrepareCallMethod extends MethodExpander {
    public PrepareCallMethod(final BlancoDbObjectStorage storage) {
        super("prepareCall");
    }

    public void setupSignature() {
        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("SQL`^ꂽSQLăvRpC{܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("IConnection.prepareCallĂяo܂B<br>");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());
        implementor.addStatement("close()");
        implementor.addStatement("prepareCall(getQuery())");
    }
}