package blanco.db.expander.query;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

public class Finalize extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private String className = null;

    public Finalize(final BlancoDbObjectStorage storage, final String className) {
        super("finalize");
        this.storage = storage;
        this.className = className;
    }

    protected Scope getScope() {
        return Scope.PROTECTED;
    }

    public void setupSignature() {
        getJavaDoc().addException(new Type(Throwable.class),
                "finalize̒ŔOB");
        addException(Throwable.class);

        getJavaDoc().addLine("finalize\bhB");
        getJavaDoc().addLine("");
        getJavaDoc()
                .addLine(
                        "̃NXIɐIuWFNĝȂŁAclose()ĂяoYoO݂邩ǂ`FbN܂B<br>");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addLine("super.finalize();");
        implementor.addLine("if (fStatement != null) {");
        implementor.addLine("final String message = \"" + className
                + " : close()\bhɂ郊\[X̊JsĂ܂B\";");
        implementor.addLine("System.out.println(message);");

        if (storage.getSetting().isLogging()) {
            implementor.addLine("");
            implementor.addLine("fLog.error(\"" + getName()
                    + ": \" + message);");
        }

        implementor.addLine("}");
    }
}