/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;

/**
 * f[^x[X̏̌ʁA1sf[^ύXȂƂONX <br>
 * ̃NXNXblancoDb\[XR[hŗp܂ <br>
 * 
 * @since 2005.05.12
 * @author IGA Tosiki
 */
public class TooManyRowsModifiedExceptionClass extends ClassExpander {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "TooManyRowsModifiedException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX̃CX^X𐶐܂B";

    /**
     * g̃^CvB
     */
    private Type fType = null;

    public TooManyRowsModifiedExceptionClass(final Type argType) {
        super(argType);
        fType = argType;
    }

    protected void expandClassStruct() {
        setSuperClass(new Type(Type.getPackage(fType.getFullName()),
                "NotSingleRowException"));

        getJavaDoc().addLine("f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>");
        getJavaDoc().addLine("̃NXblancoDb\[XR[hŗp܂ <br>");
        getJavaDoc().addLine("̃NX́A\[XR[h̃t@CƂėp܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("@since 2005.05.12");
        getJavaDoc().addLine("@author blanco Framework");

        final FieldExpander fieldCode = new FieldExpander(new Type(
                "java.lang.String"), "SQLSTATE_TOOMANYROWSMODIFIED") {
            protected Scope getScope() {
                return Scope.PROTECTED;
            }

            protected boolean isStatic() {
                return true;
            }

            protected boolean isFinal() {
                return true;
            }
        };
        fieldCode.getJavaDoc().addLine("̃NX\SQLStateR[hB<br>");
        fieldCode.getJavaDoc().addLine(
                "̃NX𗘗pۂɂ́ASQLStateɂ͗炸ɗONX̌^ɂďԂ𔻒f悤ɂĂB");
        fieldCode.setDefaultStatement(new Statement("\"00112\""));
        addField(fieldCode);

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addLine("");
                getJavaDoc().addLine(
                        "@deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B");

            }

            public void implement() {
                getData()
                        .addLine(
                                "super(\"Too many rows modified exception has occured..\", SQLSTATE_TOOMANYROWSMODIFIED);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
            }

            public void implement() {
                getData().addLine(
                        "super(reason, SQLSTATE_TOOMANYROWSMODIFIED);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("java.lang.String"), "SQLState"));
            }

            public void implement() {
                getData().addLine("super(reason, SQLState);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("java.lang.String"), "SQLState"));
                getJavaDoc().addParameter("vendorCode",
                        "f[^x[Xx_[߂ŗL̗OR[h");
                addArgument(new Value(new Type("int"), "vendorCode"));
            }

            public void implement() {
                getData().addLine("super(reason, SQLState, vendorCode);");
            }
        });
    }
}