/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;

/**
 * f[^x[XᔽɊւONX <br>
 * ̃NXNXblancoDb\[XR[hŗp܂ <br>
 * 
 * @since 2005.05.12
 * @author IGA Tosiki
 */
public class IntegrityConstraintExceptionClass extends ClassExpander {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "IntegrityConstraintException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "ᔽƂOIuWFNg ̃CX^X쐬܂B";

    public IntegrityConstraintExceptionClass(final Type argType) {
        super(argType);
    }

    protected void expandClassStruct() {
        setSuperClass(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("f[^x[XᔽɊւONX <br>");
        getJavaDoc().addLine("̃NXblancoDb\[XR[hŗp܂ <br>");
        getJavaDoc().addLine("̃NX́A\[XR[h̃t@CƂėp܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("@since 2005.05.12");
        getJavaDoc().addLine("@author blanco Framework");

        final FieldExpander fieldCode = new FieldExpander(new Type(
                "java.lang.String"), "SQLSTATE_INTEGRITYCONSTRAINT") {
            protected Scope getScope() {
                return Scope.PROTECTED;
            }

            protected boolean isStatic() {
                return true;
            }

            protected boolean isFinal() {
                return true;
            }
        };
        fieldCode.getJavaDoc().addLine("̃NX\SQLStateR[hB");
        fieldCode.setDefaultStatement(new Statement("\"23000\""));
        addField(fieldCode);

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addLine("");
                getJavaDoc()
                        .addLine(
                                "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");

            }

            public void implement() {
                getData()
                        .addLine(
                                "super(\"Integrity consrtraint exception has occured.\", SQLSTATE_INTEGRITYCONSTRAINT);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addLine("");
                getJavaDoc()
                        .addLine(
                                "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
            }

            public void implement() {
                getData().addLine(
                        "super(reason, SQLSTATE_INTEGRITYCONSTRAINT);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addLine("");
                getJavaDoc()
                        .addLine(
                                "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("java.lang.String"), "SQLState"));
            }

            public void implement() {
                getData().addLine("super(reason, SQLState);");
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("java.lang.String"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("java.lang.String"), "SQLState"));
                getJavaDoc().addParameter("vendorCode",
                        "f[^x[Xx_[߂ŗL̗OR[h");
                addArgument(new Value(new Type("int"), "vendorCode"));
            }

            public void implement() {
                getData().addLine("super(reason, SQLState, vendorCode);");
            }
        });
    }
}