/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public final class Call extends Statement {

    private List _arguments = new ArrayList();

    private String _method = "";

    private Call _call = null;

    public Call() {
        super();
    }

    public Call(String method) {
        setMethod(method);
    }

    public Call(Type type) {
        setConstructor(type);
    }

    public Call(Class constructClass) {
        setConstructor(constructClass);
    }

    public Call(Class staticTarget, String method) {
        setStaticMethod(staticTarget, method);
    }

    public Call(Type staticTarget, String method) {
        addUsingType(staticTarget);
        setMethod(staticTarget.getName() + "." + method);
    }

    private void setStaticMethod(Class targetClass, String method) {
        String className = BlancoNameAdjuster.toClassName(BlancoNameUtil
                .trimJavaPackage(targetClass.getName()));
        setMethod(className + "." + method);
        addUsingType(new Type(targetClass));
    }

    public void addArgument(String valueName) {
        _arguments.add(valueName);
    }

    public void addArgument(Statement statement) {
        _arguments.add(statement.toString());
        addSubStatement(statement);
    }

    public void addArgument(Value value) {
        _arguments.add(value.getName());
    }

    public String getStatementString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getMethod());
        sb.append("(");

        for (int i = 0; i < _arguments.size(); i++) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(_arguments.get(i).toString());
        }
        sb.append(")");
        if (_call != null) {
            sb.append(".");
            sb.append(_call.toString());
        }

        return sb.toString();
    }

    private String getMethod() {
        return _method;
    }

    public void setMethod(String name) {
        _method = name;
    }

    public void setConstructor(Type type) {
        _method = "new " + type.getName();
        addUsingType(type);
    }

    public void setConstructor(Class type) {
        setConstructor(new Type(type));
    }

    public void addStringArgument(String string) {
        _arguments.add("\"" + string + "\"");
    }

    public void addCallArgument(Call call) {
        _arguments.add(call);

    }

    public void call(Call call) {
        _call = call;
    }

    public Call call(String methodName) {
        _call = new Call(methodName);
        return _call;
    }
}
