/*
 * blancoIg Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.struts.runtime.validator;

import java.io.UnsupportedEncodingException;

import junit.framework.TestCase;

public class ValidatorTest extends TestCase {

    private String _number = "0123456789";

    private String _upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private String _lower = "abcdefghijklmnopqrstuvwxyz";

    private String _symbol = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

    private String _alphabet = _upper + _lower;

    private String _numberAlphabet = _number + _alphabet;

    private String _numberAlphabetSymbol = _number + _alphabet + _symbol;

    private String _halfKana = "ݦߡ";

    private String _half = _number + _upper + _lower + _symbol + _alphabet
            + _halfKana;

    private String _jp = "{";

    private String _fullUpper = "`abcdefghijklmnopqrstuvwxy";

    private String _fullLower = "";

    private String _fullAlphabet = _fullUpper + _fullLower;

    private String _fullNumber = "OPQRSTUVWX";

    private String _fullAlphabetNumber = _fullAlphabet + _fullNumber;

    private String _fullSymbol = "IWVij{C|D^FGHm_nOQMobp`";

    private String _fullAlphabetNumberSymbol = _fullNumber + _fullAlphabet
            + _fullSymbol;

    private String _hiragana = "ÂĂłƂǂȂɂʂ˂̂͂΂ςЂт҂ӂԂՂւׂ؂قڂۂ܂݂ނ߂JKTU";

    private String _katakana = "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~E[RS";

    private String _hiraganaKatakana = _hiragana + _katakana;

    private String _full = _jp + _fullUpper + _fullLower + _fullNumber
            + _fullSymbol + _hiragana + _katakana;

    private String _all = _half + _full;

    public void testValidateRequired() {
        String value = "";

        value = "hoge";
        assertTrue(Validator.validateRequired(value));

        value = null;
        assertTrue(!Validator.validateRequired(value));

        value = "";
        assertTrue(!Validator.validateRequired(value));

    }

    public void testValidateHalfwidth() {
        String value = "";

        value = _half;
        assertTrue(Validator.validateHalfWidth(value));

        value = null;
        assertTrue(Validator.validateHalfWidth(value));

        value = "";
        assertTrue(Validator.validateHalfWidth(value));

        value = _half + _full;
        assertTrue(!Validator.validateHalfWidth(value));

        value = _full;
        assertTrue(!Validator.validateHalfWidth(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidth(value.substring(i, i + 1)));
        }
    }

    public void testValidateFullWidth() {
        String value = "";

        value = _full;
        assertTrue(Validator.validateFullWidth(value));

        value = _half + _full;
        assertTrue(!Validator.validateFullWidth(value));

        value = _half;
        assertTrue(!Validator.validateFullWidth(value));

        value = null;
        assertTrue(Validator.validateFullWidth(value));

        value = "";
        assertTrue(Validator.validateFullWidth(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidth(value.substring(i, i + 1)));
        }
    }

    public void testValidateHalfWidhNumber() {
        String value = "";

        value = _number;
        assertTrue(Validator.validateHalfWidthNumber(value));

        value = null;
        assertTrue(Validator.validateHalfWidthNumber(value));

        value = "";
        assertTrue(Validator.validateHalfWidthNumber(value));

        value = _number + _alphabet;
        assertTrue(!Validator.validateFullWidthNumber(value));

        value = _half + _jp + _fullUpper + _fullLower + _fullSymbol + _hiragana
                + _katakana;
        assertTrue(!Validator.validateFullWidthNumber(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthNumber(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateHalfWidhAlphabet() {
        String value = "";

        value = _alphabet;
        assertTrue(Validator.validateHalfWidthAlphabet(value));

        value = "";
        assertTrue(Validator.validateHalfWidthAlphabet(value));

        value = null;
        assertTrue(Validator.validateHalfWidthAlphabet(value));

        value = _alphabet + _number;
        assertTrue(!Validator.validateHalfWidthAlphabet(value));

        value = "_";
        assertTrue(!Validator.validateHalfWidthAlphabet(value));

        value = _number + _symbol + _halfKana + _full;
        assertTrue(!Validator.validateHalfWidthAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthAlphabet(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateHalfWidthUpperCaseAlphabet() {
        String value = "";

        value = _upper;
        assertTrue(Validator.validateHalfWidthUpperCaseAlphabet(value));

        value = _upper + _lower;
        assertTrue(!Validator.validateHalfWidthUpperCaseAlphabet(value));

        value = _number + _lower + _symbol + _halfKana + _full;
        assertTrue(!Validator.validateHalfWidthUpperCaseAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthUpperCaseAlphabet(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateHalfWidthLowerCaseAlphabet() {
        String value = "";

        value = _lower;
        assertTrue(Validator.validateHalfWidthLowerCaseAlphabet(value));

        value = "";
        assertTrue(Validator.validateHalfWidthLowerCaseAlphabet(value));

        value = null;
        assertTrue(Validator.validateHalfWidthLowerCaseAlphabet(value));

        value = _lower + _upper;
        assertTrue(!Validator.validateHalfWidthLowerCaseAlphabet(value));

        value = _number + _symbol + _halfKana + _full;
        assertTrue(!Validator.validateHalfWidthLowerCaseAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthLowerCaseAlphabet(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateHalfWidthAlphabetNumber() {
        String value = "";

        value = _numberAlphabet;
        assertTrue(Validator.validateHalfWidthAlphabetNumber(value));

        value = "";
        assertTrue(Validator.validateHalfWidthAlphabetNumber(value));

        value = null;
        assertTrue(Validator.validateHalfWidthAlphabetNumber(value));

        value = _numberAlphabet + _symbol;
        assertTrue(!Validator.validateHalfWidthAlphabetNumber(value));

        value = _symbol + _halfKana + _full;
        assertTrue(!Validator.validateHalfWidthAlphabetNumber(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthAlphabetNumber(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateHalfwidthAlphabetNumberSymbol() {
        String value = "";

        value = _numberAlphabetSymbol;
        assertTrue(Validator.validateHalfWidthAlphabetNumberSymbol(value));

        value = "";
        assertTrue(Validator.validateHalfWidthAlphabetNumberSymbol(value));

        value = null;
        assertTrue(Validator.validateHalfWidthAlphabetNumberSymbol(value));

        value = _numberAlphabetSymbol + _halfKana;
        assertTrue(!Validator.validateHalfWidthAlphabetNumberSymbol(value));

        value = _halfKana + _full;
        assertTrue(!Validator.validateHalfWidthAlphabetNumberSymbol(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthAlphabetNumberSymbol(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateHalfWidthKatakana() {
        String value = "";

        value = _halfKana;
        assertTrue(Validator.validateHalfWidthKatakana(value));

        value = "";
        assertTrue(Validator.validateHalfWidthKatakana(value));

        value = null;
        assertTrue(Validator.validateHalfWidthKatakana(value));

        value = _halfKana + _number;
        assertTrue(!Validator.validateHalfWidthKatakana(value));

        value = _numberAlphabetSymbol + _full;
        assertTrue(!Validator.validateHalfWidthKatakana(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateHalfWidthKatakana(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateFullWidthUpperCaseAlphabet() {
        String value = "";

        value = _fullUpper;
        assertTrue(Validator.validateFullWidthUpperCaseAlphabet(value));

        value = "";
        assertTrue(Validator.validateFullWidthUpperCaseAlphabet(value));

        value = null;
        assertTrue(Validator.validateFullWidthUpperCaseAlphabet(value));

        value = _fullUpper + _fullLower;
        assertTrue(!Validator.validateFullWidthUpperCaseAlphabet(value));

        value = _half + _fullNumber + _fullLower + _fullSymbol
                + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthUpperCaseAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthUpperCaseAlphabet(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateFullWidthLowerCaseAlphabet() {
        String value = "";

        value = _fullLower;
        assertTrue(Validator.validateFullWidthLowerCaseAlphabet(value));

        value = "";
        assertTrue(Validator.validateFullWidthLowerCaseAlphabet(value));

        value = null;
        assertTrue(Validator.validateFullWidthLowerCaseAlphabet(value));

        value = _fullLower + _fullUpper;
        assertTrue(!Validator.validateFullWidthLowerCaseAlphabet(value));

        value = _half + _fullNumber + _fullUpper + _fullSymbol
                + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthLowerCaseAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthLowerCaseAlphabet(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateFullWidthAlphabet() {
        String value = "";

        value = _fullAlphabet;
        assertTrue(Validator.validateFullWidthAlphabet(value));

        value = "";
        assertTrue(Validator.validateFullWidthAlphabet(value));

        value = null;
        assertTrue(Validator.validateFullWidthAlphabet(value));

        value = _fullAlphabet + _fullNumber;
        assertTrue(!Validator.validateFullWidthAlphabet(value));

        value = _half + _fullNumber + _fullSymbol + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthAlphabet(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthAlphabet(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateFullWidthNumber() {
        String value = "";

        value = _fullNumber;
        assertTrue(Validator.validateFullWidthNumber(value));

        value = "";
        assertTrue(Validator.validateFullWidthNumber(value));

        value = null;
        assertTrue(Validator.validateFullWidthNumber(value));

        value = _fullNumber + _fullSymbol;
        assertTrue(!Validator.validateFullWidthNumber(value));

        value = _half + _fullAlphabet + _fullSymbol + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthNumber(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthNumber(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateFullWidthAlphabetNumber() {
        String value = "";

        value = _fullAlphabetNumber;
        assertTrue(Validator.validateFullWidthAlphabetNumber(value));

        value = "";
        assertTrue(Validator.validateFullWidthAlphabetNumber(value));

        value = null;
        assertTrue(Validator.validateFullWidthAlphabetNumber(value));

        value = _fullAlphabetNumber + _fullSymbol;
        assertTrue(!Validator.validateFullWidthAlphabetNumber(value));

        value = _half + _fullSymbol + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthAlphabetNumber(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthAlphabetNumber(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateFullWidthAlphabetNumberSymbol() {
        String value = "";

        value = _fullAlphabetNumberSymbol;
        assertTrue(Validator.validateFullWidthAlphabetNumberSymbol(value));

        value = _fullAlphabetNumberSymbol + _katakana;
        assertTrue(!Validator.validateFullWidthAlphabetNumberSymbol(value));

        value = _half + _hiraganaKatakana + _jp;
        assertTrue(!Validator.validateFullWidthAlphabetNumberSymbol(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthAlphabetNumberSymbol(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateFullWidthHiragana() {
        String value = "";

        value = _hiragana;
        assertTrue(Validator.validateFullWidthHiragana(value));

        value = "";
        assertTrue(Validator.validateFullWidthHiragana(value));

        value = null;
        assertTrue(Validator.validateFullWidthHiragana(value));

        value = _hiragana + _fullSymbol;
        assertTrue(!Validator.validateFullWidthHiragana(value));

        value = _half + _fullAlphabetNumberSymbol + _katakana;
        assertTrue(!Validator.validateFullWidthHiragana(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthHiragana(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateFullWidthKatakana() {
        String value = "";

        value = _katakana;
        assertTrue(Validator.validateFullWidthKatakana(value));

        value = "";
        assertTrue(Validator.validateFullWidthKatakana(value));

        value = null;
        assertTrue(Validator.validateFullWidthKatakana(value));

        value = _katakana + _fullSymbol;
        assertTrue(!Validator.validateFullWidthKatakana(value));

        value = _half + _fullAlphabetNumberSymbol + _hiragana;
        assertTrue(!Validator.validateFullWidthKatakana(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthKatakana(value.substring(i,
                    i + 1)));
        }
    }

    public void testValidateFullWidthKana() {
        String value = "";

        value = _hiraganaKatakana;
        assertTrue(Validator.validateFullWidthHiraganaKatakana(value));

        value = "";
        assertTrue(Validator.validateFullWidthHiraganaKatakana(value));

        value = null;
        assertTrue(Validator.validateFullWidthHiraganaKatakana(value));

        value = _hiraganaKatakana + _fullSymbol;
        assertTrue(!Validator.validateFullWidthHiraganaKatakana(value));

        value = _half + _fullAlphabetNumberSymbol;
        assertTrue(!Validator.validateFullWidthHiraganaKatakana(value));

        for (int i = 0; i < value.length(); i++) {
            assertTrue(!Validator.validateFullWidthHiraganaKatakana(value
                    .substring(i, i + 1)));
        }
    }

    public void testValidateYYYYMMDD() {
        String value = "";

        value = "20050405";
        assertTrue(Validator.validateYYYYMMDD(value));

        value = "19000101";
        assertTrue(Validator.validateYYYYMMDD(value));

        value = "20991231";
        assertTrue(Validator.validateYYYYMMDD(value));

        value = "20040229";
        assertTrue(Validator.validateYYYYMMDD(value));

        value = "";
        assertTrue(Validator.validateYYYYMMDD(value));

        value = null;
        assertTrue(Validator.validateYYYYMMDD(value));

        value = "20050229";
        assertTrue(!Validator.validateYYYYMMDD(value));

        value = "20050431";
        assertTrue(!Validator.validateYYYYMMDD(value));

        value = "2005043a";
        assertTrue(!Validator.validateYYYYMMDD(value));
    }

    public void testValidateYYMMDD() {
        String value = "";

        value = "050405";
        assertTrue(Validator.validateYYMMDD(value));

        value = "000101";
        assertTrue(Validator.validateYYMMDD(value));

        value = "991231";
        assertTrue(Validator.validateYYMMDD(value));

        value = "040229";
        assertTrue(Validator.validateYYMMDD(value));

        value = "";
        assertTrue(Validator.validateYYMMDD(value));

        value = null;
        assertTrue(Validator.validateYYMMDD(value));

        value = "050229";
        assertTrue(!Validator.validateYYMMDD(value));

        value = "050431";
        assertTrue(!Validator.validateYYMMDD(value));

        value = "05043a";
        assertTrue(!Validator.validateYYMMDD(value));
    }

    public void testValidateMMDD() {
        String value = "";
        String format = "";

        format = " (MMDD)";
        value = "0405";
        assertTrue(Validator.validateMMDD(value));

        value = "0101";
        assertTrue(Validator.validateMMDD(value));

        value = "1231";
        assertTrue(Validator.validateMMDD(value));

        value = "0228";
        assertTrue(Validator.validateMMDD(value));

        value = "";
        assertTrue(Validator.validateMMDD(value));

        value = null;
        assertTrue(Validator.validateMMDD(value));

        value = "0229";
        assertTrue(!Validator.validateMMDD(value));

        value = "0431";
        assertTrue(!Validator.validateMMDD(value));

        value = "043a";
        assertTrue(!Validator.validateMMDD(value));
    }

    private static byte getByte(int number) {
        return (byte) number;
    }

    private static void print(int num) throws UnsupportedEncodingException {
        byte hight = (byte) (num >> 8);
        byte low = (byte) (num);
        System.out.print(new String(new byte[] { hight, low }, "UTF-16"));
    }

    public static void main(String[] arguments)
            throws UnsupportedEncodingException {
        System.out.println("Ђ炪");
        for (int i = 0x3041; i <= 0x309F; i++) {
            print(i);
        }
        System.out.println();

        System.out.println("J^Ji");
        for (int i = 0x30A0; i <= 0x30FF; i++) {
            print(i);
        }
        System.out.println();

        System.out.println("L");
        for (int i = 0xFF01; i <= 0xFF0F; i++) {
            print(i);
        }
        for (int i = 0xFF1A; i <= 0xFF20; i++) {
            print(i);
        }
        for (int i = 0xFF3B; i <= 0xFF40; i++) {
            print(i);
        }
        for (int i = 0xFF5B; i <= 0xFF5E; i++) {
            print(i);
        }
        System.out.println();
    }

    public void testValidateIntRange() {
        int value = 0;
        String min = "";
        String max = "";

        value = 2;
        min = "1";
        max = "3";
        assertTrue(Validator.validateIntRange(value, min, max));

        value = -5;
        min = "-10";
        max = "-3";
        assertTrue(Validator.validateIntRange(value, min, max));

        value = -25;
        min = "";
        max = "3";
        assertTrue(Validator.validateIntRange(value, min, max));

        value = 2;
        min = "1";
        max = "";
        assertTrue(Validator.validateIntRange(value, min, max));

        value = 4;
        min = "1";
        max = "3";
        assertTrue(!Validator.validateIntRange(value, min, max));

        value = 0;
        min = "1";
        max = "3";
        assertTrue(!Validator.validateIntRange(value, min, max));

        value = 0;
        min = "aaa";
        max = "3";
        try {
            assertTrue(Validator.validateIntRange(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }

        value = 0;
        min = "5";
        max = "bbb";
        try {
            assertTrue(Validator.validateIntRange(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }
    }

    public void testValidateStringSizeByBytes() {
        String value = "";
        String min = "";
        String max = "";

        value = "hoge";
        min = "1";
        max = "5";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "hoge";
        min = "";
        max = "5";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "hoge";
        min = "1";
        max = "";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "ق";
        min = "1";
        max = "5";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "hogeHage";
        min = "1";
        max = "5";
        assertTrue(!Validator.validateStringSizeByBytes(value, min, max));

        value = "قق";
        min = "1";
        max = "8";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = null;
        min = "1";
        max = "8";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "";
        min = "1";
        max = "8";
        assertTrue(Validator.validateStringSizeByBytes(value, min, max));

        value = "ققa";
        min = "1";
        max = "8";
        assertTrue(!Validator.validateStringSizeByBytes(value, min, max));

        value = "ق";
        min = "8";
        max = "8";
        assertTrue(!Validator.validateStringSizeByBytes(value, min, max));

        value = "hoge";
        min = "1";
        max = "a";
        try {
            assertTrue(Validator.validateStringSizeByBytes(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }

        value = "hoge";
        min = "b";
        max = "5";
        try {
            assertTrue(Validator.validateStringSizeByBytes(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }
    }

    public void testValidateStringSizeByLength() {
        String value = "";
        String min = "";
        String max = "";

        value = "hoge";
        min = "1";
        max = "5";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "hoge";
        min = "";
        max = "5";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "hoge";
        min = "1";
        max = "";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "ق";
        min = "1";
        max = "2";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = null;
        min = "1";
        max = "7";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "";
        min = "1";
        max = "7";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "hogeHage";
        min = "1";
        max = "7";
        assertTrue(!Validator.validateStringSizeByLength(value, min, max));

        value = "قق";
        min = "1";
        max = "8";
        assertTrue(Validator.validateStringSizeByLength(value, min, max));

        value = "ققa";
        min = "1";
        max = "4";
        assertTrue(!Validator.validateStringSizeByLength(value, min, max));

        value = "ق";
        min = "8";
        max = "8";
        assertTrue(!Validator.validateStringSizeByLength(value, min, max));

        value = "hoge";
        min = "1";
        max = "a";
        try {
            assertTrue(Validator.validateStringSizeByLength(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }

        value = "hoge";
        min = "b";
        max = "5";
        try {
            assertTrue(Validator.validateStringSizeByLength(value, min, max));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }
    }

    public void testValidateRegex() {
        String regex = "";
        String value = "";
        String key = "key";

        regex = "[abc]";
        value = "a";
        assertTrue(Validator.validateRegex(value, regex, key));

        regex = "[abc]";
        value = null;
        assertTrue(Validator.validateRegex(value, regex, key));

        regex = "[abc]";
        value = "";
        assertTrue(Validator.validateRegex(value, regex, key));

        regex = "[abc]";
        value = "d";
        assertTrue(!Validator.validateRegex(value, regex, key));

        regex = "[a\\bc]";
        value = "d";
        try {
            assertTrue(!Validator.validateRegex(value, regex, key));
            fail();
        } catch (Exception e) {
            assertTrue("폈", true);
        }
    }
}
