/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import junit.framework.TestCase;

/**
 * @author Yasuo Nakanishi
 */
public class FieldValidationTest extends TestCase {

    public static String toString(FieldValidation target) {
        StringBuffer sb = new StringBuffer();
        sb.append("CheckRequire:");
        sb.append(target.isCheckRequire());
        sb.append(", CheckFormat:");
        sb.append(target.isCheckFormat());
        sb.append(", Format:");
        sb.append(target.getFormat());
        sb.append(", CheckRegex:");
        sb.append(target.isCheckRegex());
        sb.append(", Regex:");
        sb.append(target.getRegex());
        sb.append(", CheckSize:");
        sb.append(target.isCheckSize());
        sb.append(", MaxSize:");
        sb.append(target.getMaxSize());
        sb.append(", MinSize:");
        sb.append(target.getMinSize());
        sb.append(", CheckRange:");
        sb.append(target.isCheckRange());
        sb.append(", MaxRange:");
        sb.append(target.getMaxRange());
        sb.append(", MinRange:");
        sb.append(target.getMinRange());
        return sb.toString();
    }

    public void testAccessor() {
        FieldValidation target = create();

        String expect = "";
        expect += "CheckRequire:false";
        expect += ", CheckFormat:false";
        expect += ", Format:";
        expect += ", CheckRegex:false";
        expect += ", Regex:";
        expect += ", CheckSize:false";
        expect += ", MaxSize:";
        expect += ", MinSize:";
        expect += ", CheckRange:false";
        expect += ", MaxRange:";
        expect += ", MinRange:";

        assertEquals(expect, toString(target));
    }

    public static FieldValidation create() {
        FieldValidation result = new FieldValidation();
        return result;
    }

    public static FieldValidation createRequireOn() {
        FieldValidation result = new FieldValidation();
        result.setCheckRequire(true);
        return result;
    }

    public static FieldValidation createRequireOff() {
        FieldValidation result = new FieldValidation();
        result.setCheckRequire(false);
        return result;
    }
}
