/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.Command;
import uk.ac.ed.ph.snuggletex.definitions.CommandOrEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedCommand;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedCommandOrEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.UserDefinedEnvironment;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleInputReader;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;
import uk.ac.ed.ph.snuggletex.internal.util.ArrayListStack;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathIdentifierInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNumberInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.ErrorToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.SimpleToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class LaTeXTokeniser {
    public static final Set<String> reservedCommands = new HashSet<String>(Arrays.asList("begin", "end", "(", ")", "[", "]", "newcommand", "renewcommand", "newenvironment", "renewenvironment"));
    private static final String UDE_POST_BEGIN = "\u00a3";
    private final SessionContext sessionContext;
    private WorkingDocument workingDocument;
    private int position;
    private int startTokenIndex;
    private ModeState currentModeState;
    private final ArrayListStack<ModeState> modeStack;
    private final ArrayListStack<String> openEnvironmentStack;

    public LaTeXTokeniser(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.modeStack = new ArrayListStack();
        this.openEnvironmentStack = new ArrayListStack();
    }

    public void reset() {
        this.workingDocument = null;
        this.position = 0;
        this.startTokenIndex = -1;
        this.modeStack.clear();
        this.currentModeState = null;
        this.openEnvironmentStack.clear();
    }

    public ArgumentContainerToken tokenise(SnuggleInputReader reader) throws SnuggleParseException, IOException {
        this.reset();
        this.workingDocument = reader.createWorkingDocument();
        try {
            ModeState topLevelResult = this.tokeniseInNewState(TokenisationMode.TOP_LEVEL, null, LaTeXMode.PARAGRAPH);
            while (!this.openEnvironmentStack.isEmpty()) {
                topLevelResult.tokens.add(this.createError(CoreErrorCode.TTEE04, this.position, this.position, this.openEnvironmentStack.pop()));
            }
            ArgumentContainerToken argumentContainerToken = new ArgumentContainerToken(this.workingDocument.freezeSlice(0, this.workingDocument.length()), LaTeXMode.PARAGRAPH, topLevelResult.tokens);
            return argumentContainerToken;
        }
        finally {
            this.reset();
        }
    }

    private ModeState tokeniseInNewState(TokenisationMode tokenisationMode, Terminator terminator, LaTeXMode latexMode) throws SnuggleParseException {
        FlowToken token2;
        this.currentModeState = new ModeState(tokenisationMode, latexMode, this.position, terminator);
        this.modeStack.push(this.currentModeState);
        while ((token2 = this.readNextToken()) != null) {
            this.currentModeState.tokens.add(token2);
        }
        if (this.currentModeState.latexMode == LaTeXMode.VERBATIM && this.currentModeState.tokens.isEmpty()) {
            FrozenSlice emptySlice = this.workingDocument.freezeSlice(this.currentModeState.startPosition, this.currentModeState.startPosition);
            this.currentModeState.tokens.add(new SimpleToken(emptySlice, TokenType.VERBATIM_MODE_TEXT, LaTeXMode.VERBATIM, null, new Interpretation[0]));
        }
        if (terminator != null && !this.currentModeState.foundTerminator) {
            this.currentModeState.tokens.add(this.createError(CoreErrorCode.TTEG00, this.position, this.position, terminator));
        }
        ModeState result2 = this.currentModeState;
        this.modeStack.pop();
        this.currentModeState = this.modeStack.isEmpty() ? null : this.modeStack.peek();
        return result2;
    }

    private FlowToken readNextToken() throws SnuggleParseException {
        FlowToken result2;
        int afterTerminator;
        if (this.currentModeState.latexMode == LaTeXMode.MATH) {
            this.skipOverCommentsAndWhitespace();
        } else if (this.currentModeState.latexMode != LaTeXMode.VERBATIM) {
            this.skipOverComments();
        }
        if (this.currentModeState.terminator != null && (afterTerminator = this.currentModeState.terminator.matchesAt(this.workingDocument, this.position)) != -1) {
            this.position = afterTerminator;
            this.currentModeState.foundTerminator = true;
            return null;
        }
        if (this.position == this.workingDocument.length()) {
            return null;
        }
        this.startTokenIndex = this.position;
        switch (this.currentModeState.latexMode) {
            case PARAGRAPH: 
            case LR: {
                result2 = this.readNextTokenTextMode();
                break;
            }
            case MATH: {
                result2 = this.readNextTokenMathMode();
                break;
            }
            case VERBATIM: {
                result2 = this.readNextTokenVerbatimMode();
                break;
            }
            default: {
                throw new SnuggleLogicException("Unexpected switch case " + (Object)((Object)this.currentModeState.latexMode));
            }
        }
        if (result2 != null) {
            this.position = result2.getSlice().endIndex;
        }
        return result2;
    }

    private ErrorToken makeSubstitutionAndRewind(int startIndex, int endIndex, CharSequence replacement) throws SnuggleParseException {
        int expansionLimit = this.sessionContext.getConfiguration().getExpansionLimit();
        if (expansionLimit > 0 && this.workingDocument.getSubstitutionDepth(startIndex) >= expansionLimit) {
            return this.createError(CoreErrorCode.TTEU00, startIndex, endIndex, expansionLimit);
        }
        this.workingDocument.substitute(startIndex, endIndex, replacement);
        this.position = startIndex;
        return null;
    }

    private FlowToken readNextTokenVerbatimMode() {
        Terminator terminator = this.currentModeState.terminator;
        if (terminator == null) {
            throw new SnuggleLogicException("No terminator specified for VERBATIM Mode");
        }
        int endIndex = terminator.nextMatchFrom(this.workingDocument, this.startTokenIndex);
        if (endIndex == -1) {
            endIndex = this.workingDocument.length();
        }
        FrozenSlice verbatimContentSlice = this.workingDocument.freezeSlice(this.startTokenIndex, endIndex);
        return new SimpleToken(verbatimContentSlice, TokenType.VERBATIM_MODE_TEXT, LaTeXMode.VERBATIM, null, new Interpretation[0]);
    }

    private FlowToken readNextTokenMathMode() throws SnuggleParseException {
        int c = this.workingDocument.charAt(this.position);
        switch (c) {
            case -1: {
                return null;
            }
            case 92: {
                return this.readSlashToken();
            }
            case 123: {
                return this.readBraceRegion();
            }
            case 37: {
                throw new SnuggleLogicException("Comment should be have been skipped before getting here!");
            }
            case 38: {
                return new SimpleToken(this.workingDocument.freezeSlice(this.position, this.position + 1), TokenType.TAB_CHARACTER, this.currentModeState.latexMode, null, new Interpretation[0]);
            }
            case 35: {
                return this.createError(CoreErrorCode.TTEG04, this.position, this.position + 1, new Object[0]);
            }
            case 36: {
                return this.createError(CoreErrorCode.TTEM04, this.position, this.position + 1, new Object[0]);
            }
        }
        return this.readNextMathNumberOrSymbol();
    }

    private FlowToken readNextMathNumberOrSymbol() {
        SimpleToken numberToken = this.tryReadMathNumber();
        if (numberToken != null) {
            return numberToken;
        }
        char c = (char)this.workingDocument.charAt(this.position);
        FrozenSlice thisCharSlice = this.workingDocument.freezeSlice(this.position, this.position + 1);
        EnumMap<InterpretationType, Interpretation> interpretationMap = Globals.getMathCharacterInterpretationMap(c);
        if (interpretationMap != null) {
            return new SimpleToken(thisCharSlice, TokenType.SINGLE_CHARACTER_MATH_SPECIAL, LaTeXMode.MATH, null, interpretationMap);
        }
        return new SimpleToken(thisCharSlice, TokenType.SINGLE_CHARACTER_MATH_IDENTIFIER, LaTeXMode.MATH, null, new Interpretation[]{new MathIdentifierInterpretation(String.valueOf(c))});
    }

    private SimpleToken tryReadMathNumber() {
        int c;
        int index2 = this.position;
        boolean foundDigitsBeforeDecimalPoint = false;
        boolean foundDigitsAfterDecimalPoint = false;
        boolean foundDecimalPoint = false;
        while ((c = this.workingDocument.charAt(index2)) >= 48 && c <= 57) {
            foundDigitsBeforeDecimalPoint = true;
            ++index2;
        }
        if (this.workingDocument.charAt(index2) == 46) {
            foundDecimalPoint = true;
            ++index2;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDecimalPoint) {
            return null;
        }
        while ((c = this.workingDocument.charAt(index2)) >= 48 && c <= 57) {
            foundDigitsAfterDecimalPoint = true;
            ++index2;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDigitsAfterDecimalPoint) {
            return null;
        }
        FrozenSlice numberSlice = this.workingDocument.freezeSlice(this.position, index2);
        return new SimpleToken(numberSlice, TokenType.MATH_NUMBER, LaTeXMode.MATH, null, new Interpretation[]{new MathNumberInterpretation(numberSlice.extract())});
    }

    private FlowToken readNextTokenTextMode() throws SnuggleParseException {
        int c = this.workingDocument.charAt(this.position);
        switch (c) {
            case -1: {
                return null;
            }
            case 92: {
                return this.readSlashToken();
            }
            case 36: {
                return this.readDollarMath();
            }
            case 123: {
                return this.readBraceRegion();
            }
            case 37: {
                throw new SnuggleLogicException("Comment should be have been skipped before getting here!");
            }
            case 38: {
                return new SimpleToken(this.workingDocument.freezeSlice(this.position, this.position + 1), TokenType.TAB_CHARACTER, this.currentModeState.latexMode, null, new Interpretation[0]);
            }
            case 94: 
            case 95: {
                return this.createError(CoreErrorCode.TTEM03, this.position, this.position + 1, new Object[0]);
            }
            case 35: {
                return this.createError(CoreErrorCode.TTEG04, this.position, this.position + 1, new Object[0]);
            }
        }
        return this.readNextSimpleTextParaMode();
    }

    private SimpleToken readNextSimpleTextParaMode() {
        int c;
        SimpleToken result2 = null;
        int newLineCount = 0;
        int index2 = this.position;
        while (index2 < this.workingDocument.length()) {
            c = this.workingDocument.charAt(index2);
            if (c == 10) {
                ++newLineCount;
            } else if (!Character.isWhitespace(c)) break;
            ++index2;
        }
        if (newLineCount >= 2) {
            return new SimpleToken(this.workingDocument.freezeSlice(this.position, index2), TokenType.NEW_PARAGRAPH, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE, new Interpretation[0]);
        }
        newLineCount = 0;
        int whitespaceStartIndex = -1;
        index2 = this.position;
        while (index2 < this.workingDocument.length()) {
            c = this.workingDocument.charAt(index2);
            if (c == 92 || c == 36 || c == 123 || c == 37 || c == 38 || c == 35 || c == 94 || c == 95 || this.currentModeState.terminator != null && this.currentModeState.terminator.matchesAt(this.workingDocument, index2) != -1) break;
            if (Character.isWhitespace(c)) {
                if (whitespaceStartIndex == -1) {
                    whitespaceStartIndex = index2;
                }
                if (c == 10 && ++newLineCount == 2) {
                    break;
                }
            } else {
                newLineCount = 0;
                whitespaceStartIndex = -1;
            }
            ++index2;
        }
        result2 = newLineCount == 2 ? new SimpleToken(this.workingDocument.freezeSlice(this.position, whitespaceStartIndex), TokenType.TEXT_MODE_TEXT, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE, new Interpretation[0]) : new SimpleToken(this.workingDocument.freezeSlice(this.position, index2), TokenType.TEXT_MODE_TEXT, this.currentModeState.latexMode, TextFlowContext.ALLOW_INLINE, new Interpretation[0]);
        return result2;
    }

    private FlowToken readDollarMath() throws SnuggleParseException {
        int endContentIndex;
        int openDollarPosition = this.position;
        LaTeXMode startLatexMode = this.currentModeState.latexMode;
        boolean isDisplayMath = this.workingDocument.matchesAt(this.position, "$$");
        String delimiter = isDisplayMath ? "$$" : "$";
        this.position += delimiter.length();
        int startContentIndex = this.position;
        ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new StringTerminator(delimiter), LaTeXMode.MATH);
        int n = endContentIndex = contentResult.foundTerminator ? this.position - delimiter.length() : this.position;
        if (delimiter.equals("$") && this.workingDocument.charAt(this.position) == 36) {
            return this.createError(CoreErrorCode.TTEM01, this.position, this.position + 1, new Object[0]);
        }
        FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
        ArgumentContainerToken contentToken = new ArgumentContainerToken(contentSlice, LaTeXMode.MATH, contentResult.tokens);
        FrozenSlice environmentSlice = this.workingDocument.freezeSlice(openDollarPosition, this.position);
        BuiltinEnvironment environment = isDisplayMath ? CorePackageDefinitions.ENV_DISPLAYMATH : CorePackageDefinitions.ENV_MATH;
        return new EnvironmentToken(environmentSlice, startLatexMode, environment, contentToken);
    }

    private BraceContainerToken readBraceRegion() throws SnuggleParseException {
        int openBraceIndex = this.position++;
        LaTeXMode openLaTeXMode = this.currentModeState.latexMode;
        ModeState result2 = this.tokeniseInNewState(TokenisationMode.BRACE, new StringTerminator("}"), this.currentModeState.latexMode);
        int endInnerIndex = result2.foundTerminator ? this.position - 1 : this.position;
        FrozenSlice braceOuterSlice = this.workingDocument.freezeSlice(openBraceIndex, this.position);
        FrozenSlice braceInnerSlice = this.workingDocument.freezeSlice(openBraceIndex + 1, endInnerIndex);
        ArgumentContainerToken braceContents = new ArgumentContainerToken(braceInnerSlice, openLaTeXMode, result2.tokens);
        return new BraceContainerToken(braceOuterSlice, openLaTeXMode, braceContents);
    }

    private FlowToken readSlashToken() throws SnuggleParseException {
        FlowToken result2;
        int afterSlashIndex = this.position + 1;
        int c = this.workingDocument.charAt(afterSlashIndex);
        if (c == -1) {
            result2 = this.createError(CoreErrorCode.TTEG01, this.position, afterSlashIndex, new Object[]{this.currentModeState.latexMode});
        } else if (c == 40 || c == 91) {
            if (this.currentModeState.latexMode == LaTeXMode.MATH) {
                result2 = this.createError(CoreErrorCode.TTEM00, this.position, afterSlashIndex, new Object[0]);
            } else {
                int startCommandIndex = this.position;
                this.position += 2;
                int startContentIndex = this.position;
                String closer = c == 40 ? "\\)" : "\\]";
                ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new StringTerminator(closer), LaTeXMode.MATH);
                if (!contentResult.foundTerminator) {
                    contentResult.tokens.add(0, this.createError(CoreErrorCode.TTEM02, startCommandIndex, this.position, "\\" + Character.valueOf((char)c), closer));
                }
                int endContentIndex = contentResult.computeLastTokenEndIndex();
                FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
                FrozenSlice mathSlice = this.workingDocument.freezeSlice(startCommandIndex, this.position);
                ArgumentContainerToken contentToken = new ArgumentContainerToken(contentSlice, LaTeXMode.MATH, contentResult.tokens);
                BuiltinEnvironment environment = c == 40 ? CorePackageDefinitions.ENV_MATH : CorePackageDefinitions.ENV_DISPLAYMATH;
                result2 = new EnvironmentToken(mathSlice, this.currentModeState.latexMode, environment, contentToken);
            }
        } else {
            result2 = c == 41 || c == 93 ? this.createError(CoreErrorCode.TTEG03, this.position, this.position + 2, this.workingDocument.freezeSlice(this.position, this.position + 2).extract()) : this.readCommandOrEnvironmentOrVerb();
        }
        return result2;
    }

    private FlowToken readCommandOrEnvironmentOrVerb() throws SnuggleParseException {
        int startCommandNameIndex = this.position + 1;
        String commandName = this.readCommandOrEnvironmentName(startCommandNameIndex);
        if (commandName == null) {
            throw new SnuggleLogicException("Expected caller to have picked the commandName==null case up");
        }
        this.position += 1 + commandName.length();
        boolean isWhitespaceCommand = true;
        int i = 0;
        while (i < commandName.length()) {
            if (!Character.isWhitespace(commandName.charAt(i))) {
                isWhitespaceCommand = false;
                break;
            }
            ++i;
        }
        if (isWhitespaceCommand) {
            commandName = " ";
        }
        FlowToken result2 = null;
        result2 = commandName.equals("begin") ? this.finishBeginEnvironment() : (commandName.equals("end") ? this.finishEndEnvironment() : (commandName.equals(UDE_POST_BEGIN) ? this.handleUserDefinedEnvironmentControl() : (commandName.equals(CorePackageDefinitions.CMD_VERB.getTeXName()) ? this.finishVerbToken(CorePackageDefinitions.CMD_VERB) : (commandName.equals(CorePackageDefinitions.CMD_VERBSTAR.getTeXName()) ? this.finishVerbToken(CorePackageDefinitions.CMD_VERBSTAR) : this.finishCommand(commandName)))));
        return result2;
    }

    private String readCommandOrEnvironmentName(int startCommandNameIndex) {
        String commandName;
        int index2 = startCommandNameIndex;
        int c = this.workingDocument.charAt(index2);
        if (c == -1) {
            commandName = null;
        } else if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
            commandName = Character.toString((char)c);
        } else {
            ++index2;
            while ((c = this.workingDocument.charAt(index2)) >= 97 && c <= 122 || c >= 65 && c <= 90) {
                ++index2;
            }
            if (c == 42) {
                ++index2;
            }
            commandName = this.workingDocument.extract(startCommandNameIndex, index2).toString();
        }
        return commandName;
    }

    private FlowToken finishVerbToken(BuiltinCommand verbCommand) throws SnuggleParseException {
        int startDelimitIndex;
        int delimitChar;
        if ((delimitChar = this.workingDocument.charAt(startDelimitIndex = this.position++)) == -1) {
            return this.createError(CoreErrorCode.TTEV00, this.startTokenIndex, startDelimitIndex, new Object[0]);
        }
        if (Character.isWhitespace(delimitChar)) {
            return this.createError(CoreErrorCode.TTEV00, this.startTokenIndex, startDelimitIndex + 1, new Object[0]);
        }
        ModeState contentState = this.tokeniseInNewState(TokenisationMode.BUILTIN_COMMAND_ARGUMENT, new StringTerminator(Character.toString((char)delimitChar)), LaTeXMode.VERBATIM);
        List<FlowToken> contentTokens = contentState.tokens;
        Token verbatimContentToken = null;
        boolean endDelimiterNotFound = false;
        for (FlowToken resultToken : contentTokens) {
            if (resultToken.getType() == TokenType.VERBATIM_MODE_TEXT && verbatimContentToken == null) {
                verbatimContentToken = (SimpleToken)resultToken;
                continue;
            }
            if (resultToken.getType() == TokenType.ERROR) {
                if (((ErrorToken)resultToken).getError().getErrorCode() == CoreErrorCode.TTEG00) {
                    endDelimiterNotFound = true;
                    continue;
                }
                throw new SnuggleLogicException("Unexpected error when parsing \\verb content: " + resultToken);
            }
            throw new SnuggleLogicException("Unexpected token when examining \\verb content: " + resultToken);
        }
        if (verbatimContentToken == null) {
            throw new SnuggleLogicException("\\verb had no proper content token");
        }
        FrozenSlice contentSlice = verbatimContentToken.getSlice();
        int newlineIndex = this.workingDocument.indexOf(contentSlice.startIndex, '\n');
        if (newlineIndex != -1 && newlineIndex < contentSlice.endIndex) {
            return this.createError(CoreErrorCode.TTEV01, this.startTokenIndex, contentSlice.endIndex + (endDelimiterNotFound ? 0 : 1), new Object[0]);
        }
        FrozenSlice verbatimSlice = this.workingDocument.freezeSlice(this.startTokenIndex, this.position);
        return new CommandToken(verbatimSlice, this.currentModeState.latexMode, verbCommand, null, new ArgumentContainerToken[]{new ArgumentContainerToken(contentSlice, LaTeXMode.VERBATIM, contentTokens)});
    }

    private FlowToken finishCommand(String commandName) throws SnuggleParseException {
        BuiltinCommand builtinCommand;
        FlowToken result2 = null;
        UserDefinedCommand userCommand = this.sessionContext.getUserCommandMap().get(commandName);
        result2 = userCommand != null ? this.finishUserDefinedCommand(userCommand) : ((builtinCommand = this.sessionContext.getBuiltinCommandByTeXName(commandName)) != null ? this.finishBuiltinCommand(builtinCommand) : this.createError(CoreErrorCode.TTEC00, this.startTokenIndex, this.position, commandName));
        return result2;
    }

    private FlowToken finishBuiltinCommand(BuiltinCommand command) throws SnuggleParseException {
        if (!command.getAllowedModes().contains((Object)this.currentModeState.latexMode)) {
            return this.createError(CoreErrorCode.TTEC01, this.startTokenIndex, this.position, new Object[]{command.getTeXName(), this.currentModeState.latexMode});
        }
        if (command == CorePackageDefinitions.CMD_NEWCOMMAND || command == CorePackageDefinitions.CMD_RENEWCOMMAND) {
            return this.finishCommandDefinition(command);
        }
        if (command == CorePackageDefinitions.CMD_NEWENVIRONMENT || command == CorePackageDefinitions.CMD_RENEWENVIRONMENT) {
            return this.finishEnvironmentDefinition(command);
        }
        switch (command.getType()) {
            case SIMPLE: {
                return this.finishSimpleCommand(command);
            }
            case COMBINER: {
                return this.finishCombiningCommand(command);
            }
            case COMPLEX: {
                return this.finishComplexCommand(command);
            }
        }
        throw new SnuggleLogicException("Unexpected switch case " + (Object)((Object)command.getType()));
    }

    private FlowToken finishSimpleCommand(BuiltinCommand command) {
        boolean isFunnyCommand = false;
        String commandName = command.getTeXName();
        if (commandName.length() == 1) {
            char c = commandName.charAt(0);
            boolean bl = isFunnyCommand = !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
        }
        if (!isFunnyCommand) {
            this.skipOverTrailingWhitespace();
        }
        return new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, command);
    }

    private FlowToken finishCombiningCommand(BuiltinCommand command) throws SnuggleParseException {
        this.skipOverCommentsAndWhitespace();
        int afterWhitespaceIndex = this.position;
        int startCommandIndex = this.startTokenIndex;
        FlowToken nextToken = this.readNextToken();
        if (nextToken == null) {
            return this.createError(CoreErrorCode.TTEC03, this.startTokenIndex, afterWhitespaceIndex, command.getTeXName());
        }
        if (!command.getCombinerTargetMatcher().isAllowed(nextToken)) {
            return this.createError(CoreErrorCode.TTEC04, this.startTokenIndex, nextToken.getSlice().endIndex, command.getTeXName());
        }
        return new CommandToken(this.workingDocument.freezeSlice(startCommandIndex, nextToken.getSlice().endIndex), this.currentModeState.latexMode, command, nextToken);
    }

    private FlowToken finishComplexCommand(BuiltinCommand command) throws SnuggleParseException {
        int startCommandIndex = this.startTokenIndex;
        BuiltinCommandOrEnvironmentArgumentSearchResult argumentSearchResult = new BuiltinCommandOrEnvironmentArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverBuiltinCommandOrEnvironmentArguments(command, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        FrozenSlice commandSlice = this.workingDocument.freezeSlice(startCommandIndex, this.position);
        return new CommandToken(commandSlice, this.currentModeState.latexMode, command, argumentSearchResult.optionalArgument, argumentSearchResult.requiredArguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ErrorToken advanceOverBuiltinCommandOrEnvironmentArguments(CommandOrEnvironment commandOrEnvironment, BuiltinCommandOrEnvironmentArgumentSearchResult result2) throws SnuggleParseException {
        ModeState argumentResult;
        int c;
        LaTeXMode argumentMode;
        if (commandOrEnvironment.getArgumentCount() == 0 && !commandOrEnvironment.isAllowingOptionalArgument()) {
            result2.optionalArgument = null;
            result2.requiredArguments = ArgumentContainerToken.EMPTY_ARRAY;
            return null;
        }
        this.skipOverCommentsAndWhitespace();
        ArgumentContainerToken optionalArgument = null;
        FrozenSlice optionalArgumentSlice = null;
        int argumentIndex = 0;
        if (commandOrEnvironment.isAllowingOptionalArgument()) {
            if ((argumentMode = commandOrEnvironment.getArgumentMode(argumentIndex++)) == null) {
                argumentMode = this.currentModeState.latexMode;
            }
            if ((c = this.workingDocument.charAt(this.position)) == 91) {
                int startArgumentContentIndex = ++this.position;
                argumentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_COMMAND_ARGUMENT, new StringTerminator("]"), argumentMode);
                int endArgumentContentIndex = argumentResult.foundTerminator ? this.position - 1 : this.position;
                optionalArgumentSlice = this.workingDocument.freezeSlice(startArgumentContentIndex, endArgumentContentIndex);
                optionalArgument = new ArgumentContainerToken(optionalArgumentSlice, argumentMode, argumentResult.tokens);
            }
        }
        int argCount = commandOrEnvironment.getArgumentCount();
        ArgumentContainerToken[] requiredArguments = new ArgumentContainerToken[argCount];
        FrozenSlice[] requiredArgumentSlices = new FrozenSlice[argCount];
        int i = 0;
        while (i < argCount) {
            this.skipOverCommentsAndWhitespace();
            argumentMode = commandOrEnvironment.getArgumentMode(argumentIndex++);
            if (argumentMode == null) {
                argumentMode = this.currentModeState.latexMode;
            }
            if ((c = this.workingDocument.charAt(this.position)) == 123) {
                int startArgumentContentIndex = ++this.position;
                argumentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_COMMAND_ARGUMENT, new StringTerminator("}"), argumentMode);
                int endArgumentContentIndex = argumentResult.foundTerminator ? this.position - 1 : this.position;
                requiredArgumentSlices[i] = this.workingDocument.freezeSlice(startArgumentContentIndex, endArgumentContentIndex);
                requiredArguments[i] = new ArgumentContainerToken(requiredArgumentSlices[i], argumentMode, argumentResult.tokens);
            } else {
                if (c == -1 || i != 0 || argCount != 1 || optionalArgument != null || !(commandOrEnvironment instanceof Command)) return this.createError(commandOrEnvironment instanceof Command ? CoreErrorCode.TTEC02 : CoreErrorCode.TTEE06, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), i + 1);
                LaTeXMode currentLaTeXMode = this.currentModeState.latexMode;
                this.currentModeState.latexMode = argumentMode;
                FlowToken nextToken = this.readNextToken();
                this.currentModeState.latexMode = currentLaTeXMode;
                if (nextToken == null) return this.createError(CoreErrorCode.TTEC02, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), 1);
                requiredArguments[i] = ArgumentContainerToken.createFromSingleToken(argumentMode, nextToken);
                requiredArgumentSlices[i] = requiredArguments[i].getSlice();
            }
            ++i;
        }
        result2.optionalArgument = optionalArgument;
        result2.requiredArguments = requiredArguments;
        return null;
    }

    private FlowToken finishUserDefinedCommand(UserDefinedCommand command) throws SnuggleParseException {
        UserDefinedCommandOrEnvironmentArgumentSearchResult argumentSearchResult = new UserDefinedCommandOrEnvironmentArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverUserDefinedCommandOrEnvironmentArguments(command, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        int afterCommandIndex = this.position;
        String replacement = this.substituteArguments(command.getDefinitionSlice(), command, argumentSearchResult);
        errorToken = this.makeSubstitutionAndRewind(this.startTokenIndex, afterCommandIndex, replacement);
        return errorToken == null ? this.readNextToken() : errorToken;
    }

    private String substituteArguments(FrozenSlice slice2, UserDefinedCommandOrEnvironment commandOrEnvironment, UserDefinedCommandOrEnvironmentArgumentSearchResult argumentSearchResult) {
        boolean inEscape = false;
        boolean inArgument = false;
        StringBuilder substitutionBuilder = new StringBuilder();
        WorkingDocument sliceDocument = slice2.getDocument();
        int index2 = slice2.startIndex;
        while (index2 < slice2.endIndex) {
            char c = (char)sliceDocument.charAt(index2);
            if (!inEscape && c == '\\') {
                inEscape = true;
                substitutionBuilder.append(c);
            } else if (inEscape) {
                inEscape = false;
                substitutionBuilder.append(c);
            } else if (c == '#') {
                inArgument = true;
            } else if (inArgument) {
                inArgument = false;
                int argumentIndex = c - 48;
                if (commandOrEnvironment.isAllowingOptionalArgument()) {
                    --argumentIndex;
                }
                if (argumentIndex > 0) {
                    substitutionBuilder.append(argumentSearchResult.requiredArguments[argumentIndex - 1]);
                } else {
                    substitutionBuilder.append(argumentSearchResult.optionalArgument != null ? argumentSearchResult.optionalArgument : commandOrEnvironment.getOptionalArgument());
                }
            } else {
                substitutionBuilder.append(c);
            }
            ++index2;
        }
        return substitutionBuilder.toString();
    }

    private ErrorToken advanceOverUserDefinedCommandOrEnvironmentArguments(CommandOrEnvironment commandOrEnvironment, UserDefinedCommandOrEnvironmentArgumentSearchResult result2) throws SnuggleParseException {
        int c;
        if (commandOrEnvironment.getArgumentCount() == 0 && !commandOrEnvironment.isAllowingOptionalArgument()) {
            result2.optionalArgument = null;
            result2.requiredArguments = new CharSequence[0];
            return null;
        }
        this.skipOverCommentsAndWhitespace();
        CharSequence optionalArgument = null;
        if (commandOrEnvironment.isAllowingOptionalArgument() && (c = this.workingDocument.charAt(this.position)) == 91) {
            int openBracketIndex = this.position;
            int closeBracketIndex = this.findEndSquareBrackets(openBracketIndex);
            if (closeBracketIndex == -1) {
                return this.createError(CoreErrorCode.TTEG00, this.startTokenIndex, this.workingDocument.length(), Character.valueOf(']'));
            }
            optionalArgument = this.workingDocument.extract(openBracketIndex + 1, closeBracketIndex);
            this.position = closeBracketIndex + 1;
        }
        int argCount = commandOrEnvironment.getArgumentCount();
        CharSequence[] requiredArguments = new CharSequence[argCount];
        int i = 0;
        while (i < argCount) {
            this.skipOverCommentsAndWhitespace();
            c = this.workingDocument.charAt(this.position);
            if (c == 123) {
                int openBraceIndex = this.position;
                int closeBraceIndex = this.findEndCurlyBrackets(openBraceIndex);
                if (closeBraceIndex == -1) {
                    return this.createError(CoreErrorCode.TTEG00, this.startTokenIndex, this.workingDocument.length(), Character.valueOf('}'));
                }
                requiredArguments[i] = this.workingDocument.extract(openBraceIndex + 1, closeBraceIndex);
                this.position = closeBraceIndex + 1;
            } else if (c != -1 && i == 0 && argCount == 1 && result2.optionalArgument == null) {
                FlowToken nextToken = this.readNextToken();
                if (nextToken == null) {
                    return this.createError(CoreErrorCode.TTEC02, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), 1);
                }
                FrozenSlice nextSlice = nextToken.getSlice();
                requiredArguments[i] = nextSlice.extract();
                this.workingDocument.unfreeze(this.startTokenIndex);
            } else {
                return this.createError(commandOrEnvironment instanceof Command ? CoreErrorCode.TTEC02 : CoreErrorCode.TTEE06, this.startTokenIndex, this.position, commandOrEnvironment.getTeXName(), i + 1);
            }
            ++i;
        }
        result2.optionalArgument = optionalArgument;
        result2.requiredArguments = requiredArguments;
        return null;
    }

    private FlowToken finishBeginEnvironment() throws SnuggleParseException {
        BuiltinEnvironment builtinEnvironment;
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(CoreErrorCode.TTEE01, this.startTokenIndex, this.position, new Object[0]);
        }
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        FlowToken result2 = null;
        result2 = userEnvironment != null ? this.finishBeginUserDefinedEnvironment(userEnvironment) : ((builtinEnvironment = this.sessionContext.getBuiltinEnvironmentByTeXName(environmentName)) != null ? this.finishBeginBuiltinEnvironment(builtinEnvironment) : this.createError(CoreErrorCode.TTEE02, this.startTokenIndex, this.position, environmentName));
        return result2;
    }

    private FlowToken finishEndEnvironment() throws SnuggleParseException {
        String lastOpenName;
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(CoreErrorCode.TTEE01, this.startTokenIndex, this.position, new Object[0]);
        }
        String string2 = lastOpenName = this.openEnvironmentStack.isEmpty() ? null : this.openEnvironmentStack.peek();
        if (lastOpenName == null) {
            return this.createError(CoreErrorCode.TTEE05, this.startTokenIndex, this.position, new Object[0]);
        }
        if (!environmentName.equals(lastOpenName)) {
            return this.createError(CoreErrorCode.TTEE00, this.startTokenIndex, this.position, environmentName, lastOpenName);
        }
        this.openEnvironmentStack.pop();
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        FlowToken result2 = null;
        if (userEnvironment != null) {
            result2 = this.finishEndUserDefinedEnvironment(userEnvironment);
        } else {
            BuiltinEnvironment builtinEnvironment = this.sessionContext.getBuiltinEnvironmentByTeXName(environmentName);
            if (builtinEnvironment == null) {
                result2 = this.createError(CoreErrorCode.TTEE02, this.startTokenIndex, this.position, environmentName);
            }
        }
        return result2;
    }

    private String advanceOverBracesAndEnvironmentName() {
        this.skipOverCommentsAndWhitespace();
        if (this.workingDocument.charAt(this.position) != 123) {
            return null;
        }
        String environmentName = this.readCommandOrEnvironmentName(++this.position);
        this.position += environmentName.length();
        if (this.workingDocument.charAt(this.position) != 125) {
            return null;
        }
        ++this.position;
        return environmentName;
    }

    private FlowToken finishBeginBuiltinEnvironment(BuiltinEnvironment environment) throws SnuggleParseException {
        ArgumentContainerToken contentToken;
        int startContentIndex;
        LaTeXMode contentMode;
        BuiltinCommandOrEnvironmentArgumentSearchResult argumentSearchResult;
        ErrorToken argumentErrorToken;
        this.openEnvironmentStack.push(environment.getTeXName());
        int startEnvironmentIndex = this.startTokenIndex;
        LaTeXMode startLatexMode = this.currentModeState.latexMode;
        ErrorToken errorToken = null;
        if (!environment.getAllowedModes().contains((Object)this.currentModeState.latexMode)) {
            errorToken = this.createError(CoreErrorCode.TTEE03, this.startTokenIndex, this.position, new Object[]{environment.getTeXName(), startLatexMode});
        }
        if ((argumentErrorToken = this.advanceOverBuiltinCommandOrEnvironmentArguments(environment, argumentSearchResult = new BuiltinCommandOrEnvironmentArgumentSearchResult())) != null && errorToken == null) {
            errorToken = argumentErrorToken;
        }
        if ((contentMode = environment.getContentMode()) == null) {
            contentMode = this.currentModeState.latexMode;
        }
        if (contentMode == LaTeXMode.VERBATIM) {
            startContentIndex = this.position;
            Pattern terminatorPattern = Pattern.compile("\\\\end\\s*\\{" + environment.getTeXName() + "\\}\\s*");
            ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, new PatternTerminator(terminatorPattern), LaTeXMode.VERBATIM);
            int endContentIndex = contentResult.computeLastTokenEndIndex();
            FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
            contentToken = new ArgumentContainerToken(contentSlice, contentMode, contentResult.tokens);
            this.openEnvironmentStack.pop();
        } else {
            this.skipOverCommentsAndWhitespace();
            startContentIndex = this.position;
            ModeState contentResult = this.tokeniseInNewState(TokenisationMode.BUILTIN_ENVIRONMENT_CONTENT, null, contentMode);
            int endContentIndex = contentResult.computeLastTokenEndIndex();
            FrozenSlice contentSlice = this.workingDocument.freezeSlice(startContentIndex, endContentIndex);
            contentToken = new ArgumentContainerToken(contentSlice, contentMode, contentResult.tokens);
        }
        if (errorToken != null) {
            this.sessionContext.getErrors().remove(errorToken.getError());
            return this.createError(errorToken.getError().getErrorCode(), this.startTokenIndex, this.position, errorToken.getError().getArguments());
        }
        FrozenSlice environmentSlice = this.workingDocument.freezeSlice(startEnvironmentIndex, this.position);
        return new EnvironmentToken(environmentSlice, startLatexMode, environment, argumentSearchResult.optionalArgument, argumentSearchResult.requiredArguments, contentToken);
    }

    private FlowToken finishBeginUserDefinedEnvironment(UserDefinedEnvironment environment) throws SnuggleParseException {
        UserDefinedCommandOrEnvironmentArgumentSearchResult argumentSearchResult = new UserDefinedCommandOrEnvironmentArgumentSearchResult();
        ErrorToken errorToken = this.advanceOverUserDefinedCommandOrEnvironmentArguments(environment, argumentSearchResult);
        if (errorToken != null) {
            return errorToken;
        }
        FrozenSlice beginSlice = environment.getBeginDefinitionSlice();
        String resolvedBegin = this.substituteArguments(beginSlice, environment, argumentSearchResult);
        int endBeginIndex = this.position;
        errorToken = this.makeSubstitutionAndRewind(this.startTokenIndex, endBeginIndex, resolvedBegin = String.valueOf(resolvedBegin) + "\\\u00a3{" + environment.getTeXName() + "}");
        if (errorToken != null) {
            return errorToken;
        }
        return this.readNextToken();
    }

    private FlowToken finishEndUserDefinedEnvironment(UserDefinedEnvironment environment) throws SnuggleParseException {
        int endEndIndex = this.position;
        ErrorToken errorToken = this.makeSubstitutionAndRewind(this.startTokenIndex, endEndIndex, environment.getEndDefinitionSlice().extract());
        return errorToken == null ? this.readNextToken() : errorToken;
    }

    private FlowToken handleUserDefinedEnvironmentControl() throws SnuggleParseException {
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            throw new SnuggleLogicException("Expected to find {envName}");
        }
        UserDefinedEnvironment userEnvironment = this.sessionContext.getUserEnvironmentMap().get(environmentName);
        if (userEnvironment == null) {
            throw new SnuggleLogicException("Environment is not user-defined");
        }
        this.openEnvironmentStack.push(environmentName);
        ErrorToken errorToken = this.makeSubstitutionAndRewind(this.startTokenIndex, this.position, "");
        return errorToken == null ? this.readNextToken() : errorToken;
    }

    private FlowToken finishCommandDefinition(BuiltinCommand definitionCommand) throws SnuggleParseException {
        boolean isCommandAlreadyDefined;
        ArgumentDefinitionResult argumentDefinitionResult;
        ErrorToken error;
        String commandName;
        this.skipOverCommentsAndWhitespace();
        boolean nameIsInBraces = false;
        int c = this.workingDocument.charAt(this.position);
        if (c == -1) {
            return this.createError(CoreErrorCode.TTEUC0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (c == 123) {
            ++this.position;
            this.skipOverCommentsAndWhitespace();
            nameIsInBraces = true;
        }
        if (this.workingDocument.charAt(this.position) != 92) {
            return this.createError(CoreErrorCode.TTEUC1, this.startTokenIndex, this.position, new Object[0]);
        }
        if ((commandName = this.readCommandOrEnvironmentName(++this.position)) == null) {
            return this.createError(CoreErrorCode.TTEUC0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (reservedCommands.contains(commandName)) {
            return this.createError(CoreErrorCode.TTEUC8, this.startTokenIndex, this.position + commandName.length(), commandName);
        }
        this.position += commandName.length();
        if (nameIsInBraces) {
            this.skipOverCommentsAndWhitespace();
            if (this.workingDocument.charAt(this.position) != 125) {
                return this.createError(CoreErrorCode.TTEUC6, this.startTokenIndex, this.position, new Object[0]);
            }
            ++this.position;
        }
        if ((error = this.advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(commandName, argumentDefinitionResult = new ArgumentDefinitionResult())) != null) {
            return error;
        }
        c = this.workingDocument.charAt(this.position);
        if (c != 123) {
            return this.createError(CoreErrorCode.TTEUC3, this.startTokenIndex, this.position, commandName);
        }
        int startCurlyIndex = this.position;
        int endCurlyIndex = this.findEndCurlyBrackets(this.position);
        if (endCurlyIndex == -1) {
            return this.createError(CoreErrorCode.TTEUC2, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
        }
        this.position = endCurlyIndex + 1;
        this.skipOverCommentsAndWhitespace();
        FrozenSlice definitionSlice = this.workingDocument.freezeSlice(startCurlyIndex + 1, endCurlyIndex);
        error = this.checkDefinitionArguments(definitionSlice, commandName, argumentDefinitionResult, CoreErrorCode.TTEUCA);
        if (error != null) {
            return error;
        }
        UserDefinedCommand userCommand = new UserDefinedCommand(commandName, argumentDefinitionResult.optionalArgument, argumentDefinitionResult.requiredArgumentCount, definitionSlice);
        Map<String, UserDefinedCommand> userCommandMap = this.sessionContext.getUserCommandMap();
        boolean isRenewing = definitionCommand == CorePackageDefinitions.CMD_RENEWCOMMAND;
        boolean bl = isCommandAlreadyDefined = userCommandMap.containsKey(commandName) || this.sessionContext.getBuiltinCommandByTeXName(commandName) != null;
        if (isRenewing && !isCommandAlreadyDefined) {
            return this.createError(CoreErrorCode.TTEUC4, this.startTokenIndex, this.position, commandName);
        }
        if (!isRenewing && isCommandAlreadyDefined) {
            return this.createError(CoreErrorCode.TTEUC5, this.startTokenIndex, this.position, commandName);
        }
        userCommandMap.put(commandName, userCommand);
        return new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, definitionCommand);
    }

    private FlowToken finishEnvironmentDefinition(BuiltinCommand definitionCommand) throws SnuggleParseException {
        boolean isEnvAlreadyDefined;
        this.skipOverCommentsAndWhitespace();
        String environmentName = this.advanceOverBracesAndEnvironmentName();
        if (environmentName == null) {
            return this.createError(CoreErrorCode.TTEUE0, this.startTokenIndex, this.position, new Object[0]);
        }
        if (reservedCommands.contains(environmentName)) {
            return this.createError(CoreErrorCode.TTEUC8, this.startTokenIndex, this.position + 2 + environmentName.length(), environmentName);
        }
        this.skipOverCommentsAndWhitespace();
        ArgumentDefinitionResult argumentDefinitionResult = new ArgumentDefinitionResult();
        ErrorToken error = this.advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(environmentName, argumentDefinitionResult);
        if (error != null) {
            return error;
        }
        FrozenSlice[] definitionSlices = new FrozenSlice[2];
        int i = 0;
        while (i < 2) {
            int c = this.workingDocument.charAt(this.position);
            if (c != 123) {
                return this.createError(CoreErrorCode.TTEUE1, this.startTokenIndex, this.position, i == 0 ? "begin" : "end", environmentName);
            }
            int startCurlyIndex = this.position;
            int endCurlyIndex = this.findEndCurlyBrackets(this.position);
            this.position = endCurlyIndex + 1;
            this.skipOverCommentsAndWhitespace();
            definitionSlices[i] = this.workingDocument.freezeSlice(startCurlyIndex + 1, endCurlyIndex);
            ++i;
        }
        error = this.checkDefinitionArguments(definitionSlices[0], environmentName, argumentDefinitionResult, CoreErrorCode.TTEUE5);
        if (error == null) {
            error = this.checkDefinitionArguments(definitionSlices[1], environmentName, null, CoreErrorCode.TTEUE6);
        }
        if (error != null) {
            return error;
        }
        UserDefinedEnvironment userEnvironment = new UserDefinedEnvironment(environmentName, argumentDefinitionResult.optionalArgument, argumentDefinitionResult.requiredArgumentCount, definitionSlices[0], definitionSlices[1]);
        Map<String, UserDefinedEnvironment> userEnvironmentMap = this.sessionContext.getUserEnvironmentMap();
        boolean isRenewing = definitionCommand == CorePackageDefinitions.CMD_RENEWENVIRONMENT;
        boolean bl = isEnvAlreadyDefined = userEnvironmentMap.containsKey(environmentName) || this.sessionContext.getBuiltinEnvironmentByTeXName(environmentName) != null;
        if (isRenewing && !isEnvAlreadyDefined) {
            return this.createError(CoreErrorCode.TTEUE2, this.startTokenIndex, this.position, environmentName);
        }
        if (!isRenewing && isEnvAlreadyDefined) {
            return this.createError(CoreErrorCode.TTEUE3, this.startTokenIndex, this.position, environmentName);
        }
        userEnvironmentMap.put(environmentName, userEnvironment);
        CommandToken result2 = new CommandToken(this.workingDocument.freezeSlice(this.startTokenIndex, this.position), this.currentModeState.latexMode, definitionCommand);
        return result2;
    }

    private ErrorToken checkDefinitionArguments(FrozenSlice definitionSlice, String commandOrEnvironmentName, ArgumentDefinitionResult argumentDefinitionResult, ErrorCode errorCode) throws SnuggleParseException {
        int argumentCount = argumentDefinitionResult != null ? argumentDefinitionResult.requiredArgumentCount + (argumentDefinitionResult.optionalArgument != null ? 1 : 0) : 0;
        boolean inEscape = false;
        boolean inArgument = false;
        WorkingDocument sliceDocument = definitionSlice.getDocument();
        int index2 = definitionSlice.startIndex;
        while (index2 < definitionSlice.endIndex) {
            int c = sliceDocument.charAt(index2);
            if (!inEscape && c == 92) {
                inEscape = true;
            } else if (inEscape) {
                inEscape = false;
            } else if (c == 35) {
                inArgument = true;
            } else if (inArgument) {
                if (argumentCount == 0 || c < 49 || c > 48 + argumentCount) {
                    return this.createError(errorCode, index2 - 1, index2, commandOrEnvironmentName, Character.valueOf((char)c), argumentCount);
                }
                inArgument = false;
            }
            ++index2;
        }
        if (inArgument) {
            return this.createError(errorCode, index2 - 1, index2, commandOrEnvironmentName, null, argumentCount);
        }
        return null;
    }

    private ErrorToken advanceOverUserDefinedCommandOrEnvironmentArgumentDefinition(String commandOrEnvironmentName, ArgumentDefinitionResult result2) throws SnuggleParseException {
        this.skipOverCommentsAndWhitespace();
        int requiredArgumentCount = 0;
        String optionalArgument = null;
        int c = this.workingDocument.charAt(this.position);
        if (c == 91) {
            int afterOpenSquare = this.position + 1;
            int closeSquareIndex = this.findEndSquareBrackets(this.position);
            if (closeSquareIndex == -1) {
                return this.createError(CoreErrorCode.TTEUC9, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
            }
            this.position = closeSquareIndex + 1;
            String rawArgCount = this.workingDocument.extract(afterOpenSquare, closeSquareIndex).toString().trim();
            try {
                requiredArgumentCount = Integer.parseInt(rawArgCount);
            }
            catch (NumberFormatException e) {
                return this.createError(CoreErrorCode.TTEUC7, this.startTokenIndex, this.position, commandOrEnvironmentName, rawArgCount);
            }
            if (requiredArgumentCount < 1 || requiredArgumentCount > 9) {
                return this.createError(CoreErrorCode.TTEUC7, this.startTokenIndex, this.position, commandOrEnvironmentName, rawArgCount);
            }
            this.skipOverCommentsAndWhitespace();
            if (this.workingDocument.charAt(this.position) == 91) {
                --requiredArgumentCount;
                closeSquareIndex = this.findEndSquareBrackets(this.position);
                if (closeSquareIndex == -1) {
                    return this.createError(CoreErrorCode.TTEUC9, this.startTokenIndex, this.workingDocument.length(), new Object[0]);
                }
                optionalArgument = this.workingDocument.extract(this.position + 1, closeSquareIndex).toString();
                this.position = closeSquareIndex + 1;
            }
        }
        this.skipOverCommentsAndWhitespace();
        result2.optionalArgument = optionalArgument;
        result2.requiredArgumentCount = requiredArgumentCount;
        return null;
    }

    private int findEndSquareBrackets(int openSquareBracketIndex) {
        boolean inEscape = false;
        boolean inComment = false;
        int index2 = openSquareBracketIndex;
        while (index2 < this.workingDocument.length()) {
            int c = this.workingDocument.charAt(index2);
            if (inComment) {
                if (c == 10) {
                    inComment = false;
                }
            } else {
                if (c == 93) {
                    return index2;
                }
                if (inEscape) {
                    inEscape = false;
                } else if (c == 92) {
                    inEscape = true;
                } else if (c == 123) {
                    index2 = this.findEndCurlyBrackets(index2);
                } else if (c == 37) {
                    inComment = true;
                }
            }
            ++index2;
        }
        return -1;
    }

    private int findEndCurlyBrackets(int openBraceIndex) {
        boolean inEscape = false;
        boolean inComment = false;
        int depth = 0;
        int index2 = openBraceIndex;
        while (index2 < this.workingDocument.length()) {
            int c = this.workingDocument.charAt(index2);
            if (!inEscape && c == 92) {
                inEscape = true;
            } else if (inEscape) {
                inEscape = false;
            } else if (inComment) {
                if (c == 10) {
                    inComment = false;
                }
            } else if (c == 37) {
                inComment = true;
            } else if (c == 123) {
                ++depth;
            } else if (c == 125 && --depth == 0) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    private void skipOverCommentsAndWhitespace() {
        while (this.position < this.workingDocument.length()) {
            int c = this.workingDocument.charAt(this.position);
            if (c == 37) {
                this.skipOverComment();
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++this.position;
        }
    }

    private void skipOverComments() {
        while (this.position < this.workingDocument.length()) {
            int c = this.workingDocument.charAt(this.position);
            if (c != 37) break;
            this.skipOverComment();
        }
    }

    private void skipOverComment() {
        if (this.workingDocument.charAt(this.position) != 37) {
            return;
        }
        int index2 = this.position + 1;
        while (index2 < this.workingDocument.length() && this.workingDocument.charAt(index2) != 10) {
            ++index2;
        }
        if (this.workingDocument.charAt(index2) == 10) {
            int c;
            int searchIndex = index2 + 1;
            while (searchIndex < this.workingDocument.length() && (c = this.workingDocument.charAt(searchIndex)) != 10) {
                if (!Character.isWhitespace(c)) {
                    index2 = searchIndex;
                    break;
                }
                ++searchIndex;
            }
        }
        this.position = index2;
    }

    private void skipOverTrailingWhitespace() {
        int c;
        while (this.position < this.workingDocument.length() && Character.isWhitespace(c = this.workingDocument.charAt(this.position)) && c != 10) {
            ++this.position;
        }
    }

    private ErrorToken createError(ErrorCode errorCode, int errorStartIndex, int errorEndIndex, Object ... arguments) throws SnuggleParseException {
        FrozenSlice errorSlice = this.workingDocument.freezeSlice(errorStartIndex, errorEndIndex);
        InputError error = new InputError(errorCode, errorSlice, arguments);
        this.sessionContext.registerError(error);
        return new ErrorToken(error, this.currentModeState != null ? this.currentModeState.latexMode : LaTeXMode.PARAGRAPH);
    }

    static final class ArgumentDefinitionResult {
        public String optionalArgument;
        public int requiredArgumentCount;

        ArgumentDefinitionResult() {
        }
    }

    static class BuiltinCommandOrEnvironmentArgumentSearchResult {
        public ArgumentContainerToken optionalArgument;
        public ArgumentContainerToken[] requiredArguments;

        BuiltinCommandOrEnvironmentArgumentSearchResult() {
        }
    }

    public static class ModeState {
        public final TokenisationMode tokenisationMode;
        public LaTeXMode latexMode;
        public final int startPosition;
        public final Terminator terminator;
        public final List<FlowToken> tokens;
        public boolean foundTerminator;

        public ModeState(TokenisationMode tokenisationMode, LaTeXMode latexMode, int startPosition, Terminator terminator) {
            this.tokenisationMode = tokenisationMode;
            this.latexMode = latexMode;
            this.startPosition = startPosition;
            this.terminator = terminator;
            this.tokens = new ArrayList<FlowToken>();
            this.foundTerminator = false;
        }

        public int computeLastTokenEndIndex() {
            if (this.tokens.isEmpty()) {
                return this.startPosition;
            }
            return this.tokens.get((int)(this.tokens.size() - 1)).getSlice().endIndex;
        }
    }

    public static final class PatternTerminator
    implements Terminator {
        private final Pattern terminatorPattern;

        public PatternTerminator(Pattern terminatorPattern) {
            this.terminatorPattern = terminatorPattern;
        }

        public int matchesAt(WorkingDocument workingDocument, int index2) {
            Matcher matcher = this.terminatorPattern.matcher(workingDocument.extract());
            return matcher.find(index2) && matcher.start() == index2 ? matcher.end() : -1;
        }

        public int nextMatchFrom(WorkingDocument workingDocument, int index2) {
            Matcher matcher = this.terminatorPattern.matcher(workingDocument.extract());
            return matcher.find(index2) ? matcher.start() : -1;
        }

        public String toString() {
            return "(pattern) " + this.terminatorPattern;
        }
    }

    public static final class StringTerminator
    implements Terminator {
        private final String terminatorString;

        public StringTerminator(String terminatorString) {
            this.terminatorString = terminatorString;
        }

        public int matchesAt(WorkingDocument workingDocument, int index2) {
            return workingDocument.matchesAt(index2, this.terminatorString) ? index2 + this.terminatorString.length() : -1;
        }

        public int nextMatchFrom(WorkingDocument workingDocument, int index2) {
            return workingDocument.indexOf(index2, this.terminatorString);
        }

        public String toString() {
            return this.terminatorString;
        }
    }

    public static interface Terminator {
        public int matchesAt(WorkingDocument var1, int var2);

        public int nextMatchFrom(WorkingDocument var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenisationMode {
        TOP_LEVEL,
        BRACE,
        MATH,
        BUILTIN_COMMAND_ARGUMENT,
        BUILTIN_ENVIRONMENT_CONTENT;

    }

    static class UserDefinedCommandOrEnvironmentArgumentSearchResult {
        public CharSequence optionalArgument;
        public CharSequence[] requiredArguments;

        UserDefinedCommandOrEnvironmentArgumentSearchResult() {
        }
    }
}

