/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

public final class AccentMap {
    private static final int MIN_CODEPOINT = 32;
    private static final int MAX_CODEPOINT = 128;
    private final char[] textAccentByCodePoint = new char[96];
    private final char[] mathSafeAccentByCodePoint = new char[96];

    public AccentMap(char[] accentData, String mathUnsafeChars) {
        int i = 0;
        while (i < accentData.length) {
            char ascii = accentData[i++];
            char accented = accentData[i++];
            int index2 = this.charToIndex(ascii);
            if (index2 == -1) continue;
            this.textAccentByCodePoint[index2] = accented;
            if (mathUnsafeChars.indexOf(ascii) != -1) continue;
            this.mathSafeAccentByCodePoint[index2] = accented;
        }
    }

    public char getAccentedTextChar(char c) {
        int index2 = this.charToIndex(c);
        return index2 != -1 ? this.textAccentByCodePoint[index2] : (char)'\u0000';
    }

    public char getAccentedMathChar(char c) {
        int index2 = this.charToIndex(c);
        return index2 != -1 ? this.mathSafeAccentByCodePoint[index2] : (char)'\u0000';
    }

    private int charToIndex(char c) {
        int index2 = c - 32;
        return index2 >= 0 && index2 < 128 ? index2 : -1;
    }
}

