/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;

public final class WebPageOutputOptionsTemplates {
    public static final String DEFAULT_CONTENT_TYPE = "application/xhtml+xml";
    public static final String DEFAULT_LANG = "en";

    public static WebPageOutputOptions createWebPageOptions(WebPageOutputOptions.WebPageType webPageType) {
        ConstraintUtilities.ensureNotNull((Object)webPageType, "webPageType");
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setWebPageType(webPageType);
        switch (webPageType) {
            case MOZILLA: {
                options.setSerializationMethod(SerializationMethod.XHTML);
                options.setContentType(DEFAULT_CONTENT_TYPE);
                break;
            }
            case CROSS_BROWSER_XHTML: {
                options.setSerializationMethod(SerializationMethod.XHTML);
                options.setIncludingXMLDeclaration(true);
                options.setDoctypePublic("-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN");
                options.setDoctypeSystem("http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd");
                break;
            }
            case MATHPLAYER_HTML: {
                options.setSerializationMethod(SerializationMethod.HTML);
                options.setContentType("text/html");
                options.setPrefixingMathML(true);
                break;
            }
            case PROCESSED_HTML: {
                options.setSerializationMethod(SerializationMethod.HTML);
                options.setContentType("text/html");
                break;
            }
            case UNIVERSAL_STYLESHEET: {
                options.setSerializationMethod(SerializationMethod.XML);
                options.setIncludingXMLDeclaration(true);
                break;
            }
            case CLIENT_SIDE_XSLT_STYLESHEET: {
                options.setSerializationMethod(SerializationMethod.XML);
                break;
            }
            default: {
                throw new SnuggleRuntimeException("Unexpected switch case " + (Object)((Object)webPageType));
            }
        }
        return options;
    }
}

