/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.ErrorGroup;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CombinerTargetMatcher;
import uk.ac.ed.ph.snuggletex.definitions.CommandType;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.InterpretableSimpleMathHandler;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathInterpretation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnugglePackage {
    public static final InterpretableSimpleMathHandler interpretableSimpleMathBuilder = new InterpretableSimpleMathHandler();
    private final String name;
    private final Map<String, BuiltinCommand> builtinCommandMap;
    private final Map<String, BuiltinEnvironment> builtinEnvironmentMap;
    private final LinkedHashMap<ErrorGroup, List<ErrorCode>> errorGroupMap;
    private ResourceBundle errorMessageBundle;

    public SnugglePackage(String name) {
        ConstraintUtilities.ensureNotNull(name, "name");
        this.name = name;
        this.builtinCommandMap = new HashMap<String, BuiltinCommand>();
        this.builtinEnvironmentMap = new HashMap<String, BuiltinEnvironment>();
        this.errorGroupMap = new LinkedHashMap();
    }

    public String getName() {
        return this.name;
    }

    public Collection<ErrorGroup> getErrorGroups() {
        return this.errorGroupMap.keySet();
    }

    public Collection<ErrorCode> getErrorCodes(ErrorGroup errorGroup) {
        return this.errorGroupMap.get(errorGroup);
    }

    public ResourceBundle getErrorMessageBundle() {
        return this.errorMessageBundle;
    }

    public void setErrorMessageBundle(ResourceBundle errorMessageBundle) {
        this.errorMessageBundle = errorMessageBundle;
    }

    public BuiltinCommand getBuiltinCommandByTeXName(String texName) {
        return this.builtinCommandMap.get(texName);
    }

    public BuiltinEnvironment getBuiltinEnvironmentByTeXName(String texName) {
        return this.builtinEnvironmentMap.get(texName);
    }

    public static boolean isInputableTeXName(String texName) {
        return texName != null && (texName.charAt(0) != '<' || texName.length() <= 3 || !texName.endsWith(">"));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, Interpretation[] interpretations, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretations), handler, context, null));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation ... interpretations) {
        return this.addSimpleMathCommand(name, interpretations, (CommandHandler)interpretableSimpleMathBuilder);
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation interpretation, CommandHandler handler) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, SnugglePackage.makeInterpretationMap((Interpretation)interpretation), handler, null, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation[] interpretations, CommandHandler handler) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, SnugglePackage.makeInterpretationMap(interpretations), handler, null, null));
    }

    public BuiltinCommand addCombinerCommand(String name, EnumSet<LaTeXMode> allowedModes, CombinerTargetMatcher combinerTargetMatcher, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMBINER, false, 0, allowedModes, null, null, handler, context, combinerTargetMatcher));
    }

    public BuiltinCommand addComplexCommand(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, LaTeXMode[] argumentModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, argumentModes, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addCommand(BuiltinCommand command) {
        if (SnugglePackage.isInputableTeXName(command.getTeXName())) {
            this.builtinCommandMap.put(command.getTeXName(), command);
        }
        return command;
    }

    public BuiltinEnvironment addEnvironment(String name, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, false, 0, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretation), handler, context));
    }

    public BuiltinEnvironment addEnvironment(String name, boolean allowOptionalArgument, int argumentCount, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, allowOptionalArgument, argumentCount, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretation), handler, context));
    }

    public BuiltinEnvironment addEnvironment(BuiltinEnvironment environment) {
        if (SnugglePackage.isInputableTeXName(environment.getTeXName())) {
            this.builtinEnvironmentMap.put(environment.getTeXName(), environment);
        }
        return environment;
    }

    public static EnumMap<InterpretationType, Interpretation> makeInterpretationMap(Interpretation interpretation) {
        if (interpretation == null) {
            return null;
        }
        EnumMap<InterpretationType, Interpretation> result2 = new EnumMap<InterpretationType, Interpretation>(InterpretationType.class);
        result2.put(interpretation.getType(), interpretation);
        return result2;
    }

    public static EnumMap<InterpretationType, Interpretation> makeInterpretationMap(Interpretation ... interpretations) {
        if (interpretations.length == 0) {
            return null;
        }
        EnumMap<InterpretationType, Interpretation> result2 = new EnumMap<InterpretationType, Interpretation>(InterpretationType.class);
        Interpretation[] interpretationArray = interpretations;
        int n = interpretations.length;
        int n2 = 0;
        while (n2 < n) {
            Interpretation interpretation = interpretationArray[n2];
            result2.put(interpretation.getType(), interpretation);
            ++n2;
        }
        return result2;
    }

    public void addErrorCode(ErrorCode errorCode) {
        ConstraintUtilities.ensureNotNull(errorCode, "errorCode");
        ErrorGroup errorGroup = errorCode.getErrorGroup();
        ConstraintUtilities.ensureNotNull(errorGroup, "errorCode.errorGroup");
        List<ErrorCode> errorCodesForGroup = this.errorGroupMap.get(errorGroup);
        if (errorCodesForGroup == null) {
            errorCodesForGroup = new ArrayList<ErrorCode>();
            this.errorGroupMap.put(errorGroup, errorCodesForGroup);
        }
        errorCodesForGroup.add(errorCode);
    }

    public void addErrorCodes(ErrorCode ... errorCodes) {
        ErrorCode[] errorCodeArray = errorCodes;
        int n = errorCodes.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorCode errorCode = errorCodeArray[n2];
            this.addErrorCode(errorCode);
            ++n2;
        }
    }
}

