<?php
/*
 * @file		block.BCGroups.php
 * @brief		
 * @author		Tomomi Yamamoto
 * @date		2007.04.17
 ***************************************************************************
 *	リスト・コンテナタグ：
 *　　bitCubeの更新セット情報用、コンテナ・タグです。
 *　　アトリビュートを指定することで、特定の更新セット、指定した数の更新セットを一覧することができます。
 *  属性
 *    group_code = N
 *     ・指定されたグループ番号の情報を取得します。
 *    group_name = ""
 *     ・指定されたグループ名の情報を取得します。
 *　　lastn = N
 *     ・指定された件数を表示します。
 *    sort_order="ascend | descend"
 *     ・並べる順序を指定します。ascendを指定すると昇順、descendは降順になります。
 *　使用方法
 *	　<[BCGroups]><[/BCGroups]>
 ***************************************************************************
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

function smarty_block_BCGroups($params, $content, &$smarty, &$repeat)
{
	static $instance_cnt		= 0;			//インスタンス生成数
	static $aryloopcnt			= array();		//処理待機用配列
	static $aryrs				= array();		//検索結果待機用配列
	static $aryattribute		= array();		//属性待機用配列
	static $aryNestValue		= array();		//タグネスト時の値を待機

	//*********************
	//「開始タグ」
	//*********************
	if(is_null($content))	//コンテンツ=nullでループ回数=0の場合は初期
	{
		//初期処理
		init_BCGroups($params,&$rs);
		
		//属性設定
		attribute_BCGroups($params,&$rs,&$attribute);

		//初期化
		$loopcnt = 0;
		
		//インスタンス生成数制御
		$instance_cnt++;

		$aryNestValue[$instance_cnt] = $smarty->_tpl_vars["BCGroups"];
		
		//結果を配列へ待機
		$aryloopcnt[$instance_cnt] = $loopcnt;
		$aryrs[$instance_cnt] = $rs;
		$aryattribute[$instance_cnt] = $attribute;
		
	}

	//現在処理している情報を取得
	$loopcnt 		= $aryloopcnt[$instance_cnt];
	$rs					= $aryrs[$instance_cnt];
	$attribute	= $aryattribute[$instance_cnt];
	
	//*********************
	//「共通処理」
	//*********************
	//チェック処理
	$rtn = check_BCGroups(&$loopcnt,&$rs);
	if(!$rtn)
	{
		//終了処理		
		terminate_BCGroups(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
		$repeat = false;
		return $content;
	}	

	//メイン処理
	main_BCGroups(&$smarty,&$loopcnt,&$rs);

	//処理回数を待機
	$aryloopcnt[$instance_cnt] = $loopcnt;
	
	//*********************
	//「終了タグ」
	//*********************
	if(!is_null($content))
	{	
		if($loopcnt>$attribute['lastn'])
		{
			//終了処理
			terminate_BCGroups(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
			$repeat = false;
			return $content;
		}
		else
		{
			//処理継続
			$repeat = true;
			return $content;
		}			
	}
}

/*
 * 
 */
function init_BCGroups($params,&$rs)
{
	$dao = new BitcubeDB();
	
	//------------------------------
	//開始タグ時
	//------------------------------
	$sql  = " select distinct ";
	$sql .= "  $dao->group.group_code ";
	$sql .= " ,$dao->group.group_regist_date ";
	$sql .= " ,$dao->group.group_modification_date ";
	$sql .= " ,$dao->group.group_name ";
	$sql .= " ,$dao->group.group_meta_description ";
	$sql .= " ,$dao->group.group_meta_keyword ";
	$sql .= " ,$dao->group.group_dir_name ";
	$sql .= " ,$dao->group.group_upload_dir_name ";
	$sql .= " ,$dao->group.group_default_publish ";
	$sql .= " ,$dao->group.group_summary_strings_num ";
	$sql .= " ,$dao->group.group_rss_output_num ";
	$sql .= " ,$dao->group.group_rss1_output ";
	$sql .= " ,$dao->group.group_rss1_file_name ";
	$sql .= " ,$dao->group.group_rss2_output ";
	$sql .= " ,$dao->group.group_rss2_file_name ";
	$sql .= " ,$dao->group.group_atom_output ";
	$sql .= " ,$dao->group.group_atom_file_name ";
	$sql .= " ,$dao->group.group_rss_copyright ";
	$sql .= " ,$dao->group.group_rss_creator ";
	$sql .= " ,$dao->group.group_ping_other_sites ";
	$sql .= " ,(case when b.category_count is null then 0 else b.category_count end) as category_count ";
	$sql .= " ,(case when c.entry_count is null then 0 else c.entry_count end) as entry_count ";
	$sql .= " ,(case when d.entry_count is null then 0 else d.entry_count end) as categorize_entry_count ";
	$sql .= " ,(case when e.entry_count is null then 0 else e.entry_count end) as non_categorize_entry_count ";
	$sql .= " from ";
	$sql .= " $dao->group "; 
	$sql .= " left join (select ";
	$sql .= " group_code ";
	$sql .= " ,count(*) as category_count "; 
	$sql .= " from $dao->category ";
	$sql .= " where ($dao->category.is_delete = 0) ";
	$sql .= " group by ";
	$sql .= " group_code ";
	$sql .= " ) b on $dao->group.group_code = b.group_code ";
	$sql .= " left join (select ";
	$sql .= " group_code ";
	$sql .= " ,count(*) as entry_count "; 
	$sql .= " from $dao->entry ";
	$sql .= " where ($dao->entry.is_delete = 0) ";
	$sql .= " group by  ";
	$sql .= " group_code ";
	$sql .= " ) c on $dao->group.group_code = c.group_code ";
	$sql .= " left join (select ";
	$sql .= " group_code ";
	$sql .= " ,count(*) as entry_count "; 
	$sql .= " from $dao->entry ";
	$sql .= " where (($dao->entry.category_code > 0) and ($dao->entry.is_delete = 0)) ";
	$sql .= " group by  ";
	$sql .= " group_code ";
	$sql .= " ) d on $dao->group.group_code = d.group_code ";
	$sql .= " left join (select ";
	$sql .= " group_code ";
	$sql .= " ,count(*) as entry_count "; 
	$sql .= " from $dao->entry ";
	$sql .= " where (($dao->entry.category_code = 0) and ($dao->entry.is_delete = 0)) ";
	$sql .= " group by  ";
	$sql .= " group_code ";
	$sql .= " ) e on $dao->group.group_code = e.group_code ";
	
	//---------------
	//検索条件設定
	//---------------
	$temp_con = null;
	if(isset($params['group_code']) && $params['group_code'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCCategorys($params['group_code'],"$dao->group.group_code","int");
	}
	elseif(isset($params['group_name']) && $params['group_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCCategorys($params['group_name'],"$dao->group.group_name","char");
	}
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= " and ";
		}
		$condition .= "(".$temp_con.")";
	}
	
	$order = "";
	switch($params['sort_order'])
	{
		case "ascend":	{$order=" asc ";break;	}
		case "descend":	{$order=" desc ";break;	}
		default:{$order=" ";break;}
	}
	
	//並び替え設定
	//存在すればここで処理
	$orderby=$dao->group.'.group_code asc ';
	
	if($condition!="")
	{
		$sql .= ' where '.$dao->group.'.is_delete = 0 and '.$condition;
	}
	else
	{
		$sql .= ' where '.$dao->group.'.is_delete = 0 ';
	}
	
	if($orderby!="")
	{
		$sql .= ' order by '.$orderby;
	}
	
	$rs = array();
	$rs = $dao->GetAll($sql);
}

/*
 * 
 */
function attribute_BCGroups($params,&$rs,&$attribute)
{
	
	//表示件数設定
	//※未設定時には全て
	if(isset($params['lastn']) && $params['lastn'] != "")
	{
		$lastn = $params['lastn'];
	}
	else
	{
		$lastn = count($rs);
	}
	if($lastn>count($rs))
	{
		$lastn = count($rs);
	}
	
	//属性セット
	$attribute['lastn'] = $lastn;
}
/*
 * 
 * 
 */
function check_BCGroups(&$loopcnt,&$rs)
{
	//対象データ存在チェック
	if(($loopcnt+1)>count($rs))
	{
		return false;
	}

	return true;
}
 
/*
 * 
 */
function main_BCGroups(&$smarty,&$loopcnt,&$rs)
{
	//テンプレート変数へセット
	$items = array();

	$items['GroupCode'] = $rs[$loopcnt]['group_code'];
	$items['GroupRegistDate'] = $rs[$loopcnt]['group_regist_date'];
	$items['GroupModificationDate'] = $rs[$loopcnt]['group_modification_date'];
	$items['GroupName'] = $rs[$loopcnt]['group_name'];
	$items['GroupMetaDescription'] = $rs[$loopcnt]['group_meta_description'];
	$items['GroupMetaKeyword'] = $rs[$loopcnt]['group_meta_keyword'];
	$items['GroupHttpServerDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/";
	$items['GroupUploadDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/".$rs[$loopcnt]['group_upload_dir_name']."/";
	$items['GroupDefaultPublish'] = $rs[$loopcnt]['group_default_publish'];
	$items['GroupSummaryStringsNum'] = $rs[$loopcnt]['group_summary_strings_num'];
	$items['GroupRssOutputNum'] = $rs[$loopcnt]['group_rss_output_num'];
	$items['GroupRss1Output'] = $rs[$loopcnt]['group_rss1_output'];
	$items['GroupRss1FileName'] = $rs[$loopcnt]['group_rss1_file_name'];
	$items['GroupRss2Output'] = $rs[$loopcnt]['group_rss2_output'];
	$items['GroupRss2FileName'] = $rs[$loopcnt]['group_rss2_file_name'];
	$items['GroupAtomOutput'] = $rs[$loopcnt]['group_atom_output'];
	$items['GroupAtomFileName'] = $rs[$loopcnt]['group_atom_file_name'];
	$items['GroupRssCopyright'] = $rs[$loopcnt]['group_rss_copyright'];
	$items['GroupRssCreator'] = $rs[$loopcnt]['group_rss_creator'];
	$items['GroupPingOtherSites'] = $rs[$loopcnt]['group_ping_other_sites'];
	$items['CategoryCount'] = $rs[$loopcnt]['category_count'];
	$items['EntryCount'] = $rs[$loopcnt]['entry_count'];
	$items['CategorizeEntryCount'] = $rs[$loopcnt]['categorize_entry_count'];
	$items['NonCategorizeEntryCount'] = $rs[$loopcnt]['non_categorize_entry_count'];
	
	// 自身の変数
	$iteration = $loopcnt + 1;
	$items["iteration"] = $iteration;
	$items["first"] = ($iteration == 1) ? true : false;
	$items["last"] = ($iteration == count($rs)) ? true : false;
	
	//テンプレート変数へセット
	$smarty->assign("BCGroups", $items);
	
	$loopcnt++;
}

/*
 * 
 */
function terminate_BCGroups(&$smarty,&$instance_cnt,$aryNestValue)
{
	$smarty->clear_assign("BCGroups");
	
	//インスタンス生成数をカウントダウン
	$instance_cnt--;

	if($instance_cnt > 0)
	{
		if(isset($aryNestValue))
		{
			$smarty->assign("BCGroups",$aryNestValue);
		}
	}
	
}

function getCondition_BCGroups($value,$fieldname,$type)
{
	$temp_condition = "";
	$items = split(",",$value);

	foreach($items as $item)
	{
		if(isset($temp_con))
		{
			$temp_condition = $temp_condition." or ";
		}
		
		switch($type)
		{
			case "int":
			{
				$temp_condition = $temp_condition.$fieldname."=".$item;
				break;
			}
			default:
			{
				$temp_condition = $temp_condition.$fieldname."='".$item."'";
				break;
			}
		}	
	}
	
	return $temp_condition;
}
?>