<?php

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

function smarty_block_BCEntrySide($params,$content,&$smarty,&$repeat)
{
	if(is_null($content))
	{
		if(!isset($params["entry_code"]))
		{
			$repeat = false;
			return;
		}
		else
		{
			$entry_code    = $params["entry_code"];
			$entry_publish = (isset($params["entry_publish"])) ? $params["entry_publish"] : 1;
			$group_code    = (isset($params["group_code"])) ? $params["group_code"] : null;
			$category_code = (isset($params["category_code"])) ? $params["category_code"] : null;
			$sort_by       = (isset($params["sort_by"])) ? $params["sort_by"] : "entry_order";
			$sort_order    = (isset($params["sort_order"])) ? $params["sort_order"] : "ascend";
			
			$dao = new BitcubeDB();
			
			$sql  = " select ";
			$sql .= " $dao->entry.entry_code ";
			$sql .= " ,$dao->entry.entry_order ";
			$sql .= " from ";
			$sql .= " $dao->entry ";
			
			if(!is_null($entry_code))
			{
				$sql .= " where ";
				$sql .= " $dao->entry.is_delete = 0 ";
				
				if(!is_null($entry_publish))
				{
					$sql .= " and $dao->entry.entry_publish = ".$dao->qstr($entry_publish)." ";
				}
				
				if(!is_null($group_code))
				{
					$sql .= " and $dao->entry.group_code = ".$dao->qstr($group_code)." ";
				}
				
				if(!is_null($category_code))
				{
					$sql .= " and $dao->entry.category_code = ".$dao->qstr($category_code)." ";
				}
				
				if(!is_null($sort_by))
				{
					switch($sort_by)
					{
						case "entry_code"    : {$sql .= " order by $dao->entry.entry_code "; break;}
						case "category_code" : {$sql .= " order by $dao->entry.category_code "; break;}
						case "group_code"    : {$sql .= " order by $dao->entry.group_code "; break;}
						case "entry_order"   : {$sql .= " order by $dao->entry.entry_order "; break;}
						case "page_view"     : {$sql .= " order by $dao->entry.entry_page_view "; break;}
						case "adddate"       : {$sql .= " order by $dao->entry.entry_regist_date "; break;}
						case "upddate"       : {$sql .= " order by $dao->entry.entry_modification_date "; break;}
						default              : {$sql .= " order by $dao->entry.entry_order "; break;}
					}
					
					if($sort_order == "ascend")
					{
						$sql .= " asc ";
					}
					else if($sort_order == "descend")
					{
						$sql .= " desc ";
					}
				}
				
				$rs = $dao->Execute($sql);
				
				if($rs->RecordCount() > 0)
				{
					$entry_side = array();
					while(!$rs->EOF)
					{
						$fields = $rs->fields;
						if($fields["entry_code"] == $entry_code)
						{
							$rs->MoveNext();
							if(!$rs->EOF)
							{
								$entry_side["next"] = $rs->fields["entry_code"];
							}
							break;
						}
						$entry_side["prev"] = $fields["entry_code"];
						$rs->MoveNext();
					}
				}
				
				$items  = array();
				$result = array();
				
				$sql  = " select "; 
				$sql .= " $dao->entry.entry_code ";
				$sql .= " ,$dao->entry.group_code ";
				$sql .= " ,$dao->entry.category_code ";
				$sql .= " ,$dao->entry.entry_regist_date ";
				$sql .= " ,$dao->entry.entry_modification_date ";
				$sql .= " ,$dao->entry.entry_date ";
				$sql .= " ,$dao->entry.entry_publish ";
				$sql .= " ,$dao->entry.entry_title ";
				$sql .= " ,$dao->entry.entry_body ";
				$sql .= " ,$dao->entry.entry_order ";
				$sql .= " ,$dao->group.group_regist_date ";
				$sql .= " ,$dao->group.group_modification_date ";
				$sql .= " ,$dao->group.group_name ";
				$sql .= " ,$dao->group.group_dir_name ";
				$sql .= " ,$dao->group.group_upload_dir_name ";
				$sql .= " ,$dao->group.group_summary_strings_num ";
				$sql .= " ,$dao->category.category_name ";
				$sql .= " ,$dao->category.category_order ";
				$sql .= " from ";
				$sql .= " $dao->entry left join $dao->group on $dao->group.is_delete = 0 and $dao->entry.group_code = $dao->group.group_code "; 
				$sql .= " left join $dao->category on $dao->category.is_delete = 0 and $dao->entry.category_code = $dao->category.category_code and $dao->entry.group_code = $dao->category.group_code ";
				
				$result["prev"] = $dao->GetRow($sql." where $dao->entry.entry_code = ".$dao->qstr($entry_side["prev"]));
				
				$description = $result["prev"]["entry_body"];
				$description = strip_tags($description);
				$description = str_replace("\n","",$description);
				
				$items["prev"]["EntryCode"] = $result["prev"]["entry_code"];
				$items["prev"]["GroupCode"] = $result["prev"]["group_code"];
				$items["prev"]["CategoryCode"] = $result["prev"]["category_code"];
				$items["prev"]["EntryRegistDate"] = $result["prev"]["entry_regist_date"];
				$items["prev"]["EntryModificationDate"] = $result["prev"]["entry_modification_date"];
				$items["prev"]["EntryDate"] = $result["prev"]["entry_date"];
				$items["prev"]["EntryPublish"] = $result["prev"]["entry_publish"];
				$items["prev"]["EntryTitle"] = $result["prev"]["entry_title"];
				$items["prev"]["EntryBody"] = $result["prev"]["entry_body"];
				$items["prev"]["EntryDescription"] = mb_substr($description,0,$result["prev"]["group_summary_strings_num"]);
				$items["prev"]["EntryOrder"] = $result["prev"]["entry_order"]; 
				$items["prev"]["GroupRegistDate"] = $result["prev"]["group_regist_date"];
				$items["prev"]["GroupModificationDate"] = $result["prev"]["group_modification_date"];
				$items["prev"]["GroupName"] = $result["prev"]["group_name"];	
				$items["prev"]["GroupHttpServerDirPath"] = CURRENT_HTTP_SERVER.$result["prev"]["group_dir_name"]."/";
				$items["prev"]["GroupUploadDirPath"] = CURRENT_HTTP_SERVER.$result["prev"]["group_dir_name"]."/".$result["prev"]["group_upload_dir_name"]."/";
				$items["prev"]["CategoryName"] = $result["prev"]["category_name"];
				$items["prev"]["CategoryOrder"] = $result["prev"]["category_order"];
				
				$result["next"] = $dao->GetRow($sql." where $dao->entry.entry_code = ".$dao->qstr($entry_side["next"]));
				
				$description = $result["next"]["entry_body"];
				$description = strip_tags($description);
				$description = str_replace("\n","",$description);
				
				$items["next"]["EntryCode"] = $result["next"]["entry_code"];
				$items["next"]["GroupCode"] = $result["next"]["group_code"];
				$items["next"]["CategoryCode"] = $result["next"]["category_code"];
				$items["next"]["EntryRegistDate"] = $result["next"]["entry_regist_date"];
				$items["next"]["EntryModificationDate"] = $result["next"]["entry_modification_date"];
				$items["next"]["EntryDate"] = $result["next"]["entry_date"];
				$items["next"]["EntryPublish"] = $result["next"]["entry_publish"];
				$items["next"]["EntryTitle"] = $result["next"]["entry_title"];
				$items["next"]["EntryBody"] = $result["next"]["entry_body"];
				$items["next"]["EntryDescription"] = mb_substr($description,0,$result["next"]["group_summary_strings_num"]);
				$items["next"]["EntryOrder"] = $result["next"]["entry_order"]; 
				$items["next"]["GroupRegistDate"] = $result["next"]["group_regist_date"];
				$items["next"]["GroupModificationDate"] = $result["next"]["group_modification_date"];
				$items["next"]["GroupName"] = $result["next"]["group_name"];	
				$items["next"]["GroupHttpServerDirPath"] = CURRENT_HTTP_SERVER.$result["next"]["group_dir_name"]."/";
				$items["next"]["GroupUploadDirPath"] = CURRENT_HTTP_SERVER.$result["next"]["group_dir_name"]."/".$result["next"]["group_upload_dir_name"]."/";
				$items["next"]["CategoryName"] = $result["next"]["category_name"];
				$items["next"]["CategoryOrder"] = $result["next"]["category_order"];
				
				$smarty->assign("BCEntrySide",$items);
			}
			else
			{
				$repeat = false;
				return;
			}
		}
	}
	else
	{
		$repeat = false;
		return $content;
	}
}
