<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		FileUploadInputForm.class.php
 * @brief		ファイルアップロードフォームクラス
 * @date		2007.02.02
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");

class FileUploadInputForm extends AbstractForm
{
	function setFileName($file_name="")
	{
		$this->file_name = $file_name;
	}
	
	function setFileSize($file_size="")
	{
		$this->file_size = $file_size;
	}
	
	function check()
	{
		$error_array = array();
		if(!is_null($this->file_name))
			if(!strlen($this->file_name))
				$error_array["file_name"] = "ファイル名を入力してください。";
			else if(!is_filename($this->file_name))
				$error_array["file_name"] = "ファイル名に使用できない文字が含まれています。";
			else if($this->file_array)
				foreach($this->file_array as $file)
					if($file["name"] == $this->file_name)
						$error_array["file_name"] = "既に存在するファイル名です。";
		if(!is_null($this->file_size))
			if($this->file_size > 2097152)
				$error_array["file_size"] = "ファイルサイズが2MBを超えています。";
		return $error_array;
	}
}
