<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralNewsManager.class.php
 * @brief		一般用ニュース詳細ページクラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class GeneralNewsManager extends BitcubeDB
{
	function GeneralNewsManager()
	{
		$this->BitcubeDB();
	}
	
	// タイトル取得
	function getNewsTitle($entry_code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_title ";
		$sql .= " from ";
		$sql .= " $this->entry ";
		$sql .= " where $this->entry.is_delete = 0 and $this->entry.entry_publish = 1 and $this->entry.entry_code = $entry_code ";
		
		return $this->GetOne($sql);
	}
	
	// ニュース詳細ページ情報取得
	function getNewsInfo($group_code,$entry_code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " ,$this->entry.group_code ";
		$sql .= " ,$this->entry.category_code ";
		$sql .= " ,$this->entry.entry_body ";
		$sql .= " ,$this->template.news_detail_tmpl ";
		$sql .= " from ";
		$sql .= " $this->entry left outer join $this->template on $this->template.group_code = $this->entry.group_code ";
		$sql .= " where $this->entry.is_delete = 0 and $this->entry.group_code = $group_code and $this->entry.entry_publish = 1 and $this->entry.entry_code = $entry_code ";
		
		return $this->GetRow($sql);
	}
	
	// 閲覧数カウント
	function updPageView($code)
	{
		$record["entry_page_view"] = $this->GetOne("select $this->entry.entry_page_view from $this->entry where $this->entry.entry_code = ".$code) + 1;
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
}
