<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateModuleDelete.class.php
 * @brief		モジュールテンプレートの削除クラス
 * @date		2007.01.29
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/TemplateModuleManager.class.php");

class TemplateModuleDelete extends PageRender
{
	function makePage()
	{
		$dao = new TemplateModuleManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->delTemplateModule($_GET["module_code"]);
		if(!$dao->CompleteTrans())
			$this->error("モジュールテンプレートの削除に失敗しました。");
		
		$send_vars["mode"] = 8;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
