<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		SendPingEdit.class.php
 * @brief		記事をPRする先の編集クラス
 * @date		2006.12.17
 */

require_once(CLASS_DIR."/form/SendPingInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class SendPingEdit extends SendPingInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; 更新を通知");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("ping_other_sites",$this->current_group["group_ping_other_sites"]);
		$this->template = "SendPingEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setPingOtherSites($_POST["ping_other_sites"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "SendPingEditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "SendPingEditConfirm.tpl";
		}
		
		$this->assign("ping_other_sites",$_POST["ping_other_sites"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_ping_other_sites"] = $_POST["ping_other_sites"];
		$code = $_GET["group_code"];
		
		$dao = new GroupManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->updGroup($record,$code);
		if(!$dao->CompleteTrans())
			$this->error("更新セットの修正に失敗しました。");
		
		$_POST["state"] = 1;
		$this->assign("message_array","変更内容を保存しました。");
		
		$this->makeForm();
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
