<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryCopy.class.php
 * @brief		記事の複製クラス
 * @date		2007.01.16
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class EntryCopy extends PageRender
{
	function makePage()
	{
		$dao = new EntryManager();
		$current_entry = $dao->getEntryInfo($_GET["entry_code"]);
		
		$new_entry_code = $dao->getNextEntryCode();
		
		while(!$fp = fopen(LOCK_DIR."/".$new_entry_code,"x"))
			$new_entry_code++;
		ftruncate($fp,0);
		fclose($fp);
		
		$record = array();
		$record["entry_code"] = $new_entry_code;
		$record["group_code"] = $current_entry["group_code"];
		$record["category_code"] = $current_entry["category_code"];
		$record["entry_date"] = $current_entry["entry_date"];
		$record["entry_title"] = $current_entry["entry_title"]."(コピー)";
		$record["entry_body"] = $current_entry["entry_body"];
		$record["entry_page_view"] = 0;
		
		$dao->StartTrans();
		$dao->Lock();
		$dao->insEntry($record);
		if(!$dao->CompleteTrans())
			$this->error("記事の複製に失敗しました。");
		system("cp -r \"".DATA_DIR."/".$_GET["group_code"]."/".$_GET["entry_code"]."\" \"".DATA_DIR."/".$_GET["group_code"]."/".$new_entry_code."\" ");
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
