<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CategoryList.class.php
 * @brief		カテゴリ一覧クラス
 * @date		2006.12.19
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");

class CategoryList extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; カテゴリ一覧");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$current_group);
		
		$category_dao = new CategoryManager();
		$group_category_array = $category_dao->getCategoryList("$category_dao->category.category_order desc","$category_dao->category.group_code = ".$_GET["group_code"]);
		
		$this->assign("group_category_array",$group_category_array);
		
		$this->template = "CategoryList.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
