<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CategoryEdit.class.php
 * @brief		カテゴリの編集クラス
 * @date		2006.12.20
 */

require_once(CLASS_DIR."/form/CategoryInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");

class CategoryEdit extends CategoryInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; <a href=\"./index.php?mode=15&group_code=".$_GET["group_code"]."\">カテゴリ一覧</a> &gt; カテゴリ編集");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$current_group);
		
		$dao_category = new CategoryManager();
		$this->current_category = $dao_category->getCategoryInfo($_GET["category_code"]);
		if(!count($this->current_category) > 0)
			$this->error("カテゴリ情報の取得に失敗しました。");
		$this->assign("current_category",$this->current_category);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("name",$this->current_category["category_name"]);
		$this->template = "CategoryEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setCategoryName($_POST["name"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "CategoryEditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "CategoryEditConfirm.tpl";
		}
		
		$this->assign("name",$_POST["name"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_code"] = $_GET["group_code"];
		$record["category_name"] = $_POST["name"];
		$code = $_GET["category_code"];
		
		$category = new CategoryManager();
		$category->StartTrans();
		$category->Lock();
		$category->updCategory($record,$code);
		if(!$category->CompleteTrans())
			$this->error("カテゴリの修正に失敗しました。");
		
		$send_vars["mode"] = 15;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
