<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccountEdit.class.php
 * @brief		ユーザ設定クラス
 * @date		2007.01.18
 */

require_once(CLASS_DIR."/form/AccountInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/AccountManager.class.php");

class AccountEdit extends AccountInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; ユーザ設定");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("username",$_SESSION["auth_username"]);
		$this->template = "AccountEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setAccountName($_POST["username"]);
		$this->setAccountPass($_POST["password"]);
		$this->setConfirmPass($_POST["cpassword"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "AccountEditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("password",$_POST["password"]);
			$this->assign("error_array","ユーザ名・パスワードは大切に保管してください");
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "AccountEditConfirm.tpl";
		}
		
		$this->assign("username",$_POST["username"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["account_name"] = $_POST["username"];
		$record["account_pass"] = $_POST["password"];
		
		$dao = new AccountManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->updAccount($record,$_SESSION["auth_username"]);
		if(!$dao->CompleteTrans())
			$this->error("ユーザ設定の修正に失敗しました。");
		
		// セッションを新しいユーザ設定に書き換え
		$_SESSION["auth_username"] = $_POST["username"];
		$_SESSION["auth_password"] = md5($_POST["password"]);
		
		$_POST["state"] = 1;
		$this->assign("message_array","変更内容を保存しました。");
		
		$this->makeForm();
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
