// -*- C++ -*-
/*!
 * @file  UrgHandlerCsv.cpp
 * @brief URG handler component
 * $Date$
 *
 * $Id$
 */

#include "UrgHandlerCsv.h"

// Module specification
// <rtc-template block="module_spec">
static const char* urghandlercsv_spec[] =
  {
    "implementation_id", "UrgHandlerCsv",
    "type_name",         "UrgHandlerCsv",
    "description",       "URG handler component",
    "version",           "0.0.1",
    "vendor",            "Satofumi KAMIMURA",
    "category",          "Sensor Handling",
    "activity_type",     "DataFlowComponent",
    "max_instance",      "10",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.output", "csv",
    "conf.default.serial", "00704464",

    ""
  };
// </rtc-template>

UrgHandlerCsv::UrgHandlerCsv(RTC::Manager* manager)
  : RTC::DataFlowComponentBase(manager),
    // <rtc-template block="initializer">
    m_inIn("in", m_in),
    //m_outOut("out", m_out),
    
    // </rtc-template>
	dummy(0)
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  registerInPort("in", m_inIn);
  
  // Set OutPort buffer
  //registerOutPort("out", m_outOut);
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

}

UrgHandlerCsv::~UrgHandlerCsv()
{
}


RTC::ReturnCode_t UrgHandlerCsv::onInitialize()
{
  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("output", m_output, "csv");
  bindParameter("serial", m_serial, "00704464");

  // </rtc-template>
  return RTC::RTC_OK;
}



/*
RTC::ReturnCode_t UrgHandlerCsv::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t UrgHandlerCsv::onExecute(RTC::UniqueId ec_id)
{
  if (m_inIn.isNew())
    {
      m_inIn.read();
      std::cout << "Received: " << m_in.data << std::endl;
      std::cout << "TimeStamp: " << m_in.tm.sec << "[s] ";
      std::cout << m_in.tm.nsec << "[ns]" << std::endl;
    }
  usleep(1000);

  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t UrgHandlerCsv::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t UrgHandlerCsv::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{

  void UrgHandlerCsvInit(RTC::Manager* manager)
  {
    RTC::Properties profile(urghandlercsv_spec);
    manager->registerFactory(profile,
                             RTC::Create<UrgHandlerCsv>,
                             RTC::Delete<UrgHandlerCsv>);
  }

};


