/*!
  \file
  \brief UrgCtrl  OpenRTM pbp[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgDeviceCtrl.h"
#include "UrgCtrl.h"
#include "UrgIdHandler.h"


struct UrgDeviceCtrl::pImpl {
  UrgCtrl urg;
  std::string error_message;
  char* output_buffer;
  bool have_data;
  long last_timestamp;

  pImpl(const char* devices)
    : error_message(urg.what()), output_buffer(NULL), have_data(false),
      last_timestamp(-1) {
  }

  ~pImpl(void) {
    delete [] output_buffer;
  }
};


UrgDeviceCtrl::UrgDeviceCtrl(const char* devices)
  : pimpl(new pImpl(devices)) {
}


UrgDeviceCtrl::~UrgDeviceCtrl(void) {
}


const char* UrgDeviceCtrl::what(void) {
  return pimpl->error_message.c_str();
}


bool UrgDeviceCtrl::connect(const char* device, const char* serial) {

  // !!! ܂́Aserial CɂĂ݂

  if (! pimpl->urg.connect(device)) {
    pimpl->error_message = pimpl->urg.what();
    return false;
  }
  //pimpl->urg.setLaserOutput(true);
  pimpl->urg.setCaptureMode(UrgCtrl::AutoCapture);

  return true;
}


void UrgDeviceCtrl::disconnect(void) {
  pimpl->urg.disconnect();
}


bool UrgDeviceCtrl::isConnected(void) {
  return pimpl->urg.isConnected();
}


#if 0
void UrgDeviceCtrl::handleCommand(const char* command) {
  static long* data = NULL;
  static size_t data_max = 0;

  if ((data == NULL) && (pimpl->urg.isConnected())) {
    data_max = pimpl->urg.getMaxDataLength();
    fprintf(stderr, "data_max: %d\n", data_max);
    data = new long [data_max];

    pimpl->output_buffer = new char[(data_max + 6) * 6];
  }
  if (data == NULL) {
    return;
  }

  int n = strlen(command);
  if (n <= 2) {
    // Ȏw
    return;
  }

  // "CSV" ̏
  size_t data_num = 0;
  if (! strcmp("CSV", command)) {
    // !!!
    data_num = pimpl->urg.capture(data, data_max);
    if (data_num < data_max) {
      return;
    }
  }

  // "GD", "MD" ̏
  // !!!

  // o̓tH[}bg
  // ȉ̃f[^, P̕, ŏ̃CfbNXp, Ō̃CfbNXp,
  // f[^, f[^, ...
  // !!! string ɕǉāAC邪...
  int filled = 0;
  for (size_t i = 0; i < data_num; ++i) {
    sprintf(&pimpl->output_buffer[filled], "%ld,", data[i]);
    int add_size = strlen(&pimpl->output_buffer[filled]);
    filled += add_size;
  }
  pimpl->output_buffer[filled] = '\0';
  pimpl->have_data = true;
}
#endif

void UrgDeviceCtrl::startCapture(void) {
  pimpl->urg.startCaptures();
}


void UrgDeviceCtrl::stopCapture(void) {
  pimpl->urg.stopCaptures();
}


void UrgDeviceCtrl::updateData(void) {
  static long* data = NULL;
  static size_t data_max = 0;

  if ((data == NULL) && (pimpl->urg.isConnected())) {
    data_max = pimpl->urg.getMaxDataLength();
    printf("data_max: %d\n", data_max);
    data = new long [data_max];

    pimpl->output_buffer = new char[(data_max + 6) * 6];
  }
  if (data == NULL) {
    return;
  }

  int data_num = pimpl->urg.capture(data, data_max);
  int timestamp = pimpl->urg.getTimestamp();
  if ((data_num <= 0) || (timestamp == pimpl->last_timestamp)) {
    return;
  }
  printf("data: %d, timestamp: %d\n", data_max, timestamp);

  int filled = 0;
  for (int i = 0; i < data_num; ++i) {
    sprintf(&pimpl->output_buffer[filled], "%ld,", data[i]);
    int add_size = strlen(&pimpl->output_buffer[filled]);
    filled += add_size;
  }
  pimpl->output_buffer[filled] = '\0';
  pimpl->have_data = true;
  pimpl->last_timestamp = timestamp;
}


bool UrgDeviceCtrl::haveData(void) {
  // !!! 擾f[^΁AM
  return pimpl->have_data;
}


const char* UrgDeviceCtrl::sendData(void) {
  pimpl->have_data = false;
  return pimpl->output_buffer;
}
