#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG 

  \author Satofumi KAMIMURA

  $Id$

  \todo ^CX^v܂AtimestampAdjust/ ɈړBRunCtrl ̎ł悢
*/

#include "RangeSensorInterface.h"
#include <memory>

class ConnectionInterface;
class SensorParameter;


/*!
  \brief SCIP2.0 Kiɂ URG 
*/
class UrgCtrl : public RangeSensorInterface {
  UrgCtrl(const UrgCtrl& rhs);
  UrgCtrl& operator = (const UrgCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum {
    NotConnected = -1,
    DefaultBaudrate = 115200,

    Infinity = -1,

    VEND = 0,			// x_
    PROD,			// i
    FIRM,			// t@[EFAo[W
    PROT,			// vgRo[W
    SERI,			// ZTŗLVAԍ
  };

  typedef enum {
    ManualCapture,
    AutoCapture,
  } CaptureMode;

  UrgCtrl(void);
  ~UrgCtrl(void);
  const char* what(void);

  /*!
    \brief ڑ

    ͂Ă̐ڑBȉ̃IvV͉\

    - --urg_port=<port> ... ڑ|[gw
    - --urg_baudrate=<port> ... ڑ{[[gw
    - --urg_handstand ... URG ̎擾f[^̔zuJnƏIŔ]

    \retval true ڑ
    \retval false ڑɎs
  */
  bool connect(int argc, char* argv[]);
  bool connect(const char* device, long baudrate = DefaultBaudrate);
  bool connect(ConnectionInterface* con);
  void disconnect(void);
  bool isConnected(void);

  /*!
    \brief o[W̕Ԃ

    \param lines [o] o[W̕

    \todo ڂLqB̗
  */
  bool getVersionInfo(std::vector<std::string>& lines);

  long getMinDistance(void) const;
  long getMaxDistance(void) const;
  int getMaxDataLength(void) const;

  // f[^擾
  int capture(long data[], size_t max_size);

  // pxϊ
  double index2rad(const int index) const;
  int rad2index(const double radian) const;

  void adjustTimestamp(int set_value = 0);

  /*!
    \brief PC Œ^CX^v̎擾

    \attention capture() łȂ΁A̒l͖
   */
  long getTimestamp(void);


  bool loadSensorParameter(SensorParameter* parameter);
  void setSensorParameter(const SensorParameter* parameter);
  void setHandstand(bool on = true);

  /*!
    \brief 擾[h̐ݒ

    \param mode [i] 擾[hݒ (AutoCapture / ManualCapture)

    \code
UrgCtrl urg;
urg.setCaptureMode(UrgCtrl::AutoCapture);
    \endcode

    擾[h̏ڍׂ \ref compare_auto_manual_page QƂ̂ƁB
  */
  void setCaptureMode(CaptureMode mode);

  // 擾obt@̐ݒ
  void setMaxBufferNum(size_t size);

  // t[̊Ԉ
  void setFrameSkipFrames(size_t skip_frames);

  // f[^܂Ƃ߂O[v
  void setDataGroups(size_t groups);

  // 擾͈͂̎w
  void setCaptureRange(int first_index, int last_index);

  // [Ȕo͐
  void setLaserOutput(bool on);

  // f[^擾̊Jn
  void startCaptures(void);

  void stopCaptures(void);

  // O capture() ̃^CX^vԂ
  unsigned long getRawTimestamp(void);

  int getScanMsec(void);
};

#endif /* !URG_CTRL_H */
