/*!
  \file
  \brief t@C̃pXT

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SearchFilePath.h"
#include <unistd.h>


bool searchFilePath(std::string& full_path, const char* fname,
		    const std::vector<std::string>& dir_path) {

  // t@C݂̑ɊmF
  for (std::vector<std::string>::const_iterator it = dir_path.begin();
       it != dir_path.end(); ++it) {

    // "~/" ϐ HOME ̓eɒu
    std::string replaced = *it;

    size_t match_index = it->find("~/");
    if (match_index != std::string::npos) {
      const char* home = getenv("HOME");
      if (home != NULL) {
	size_t n = strlen(home);
	replaced.replace(match_index, 1, home, n);
      }
    }
    std::string try_path = replaced + "/" + fname;
    if (access(try_path.c_str(), F_OK) == 0) {
      full_path = try_path;
      return true;
    }
  }
  return false;
}
