#ifndef RANGE_SENSOR_INTERFACE_H
#define RANGE_SENSOR_INTERFACE_H

/*!
  \file
  \brief WZTpC^[tF[X

  \author Satofumi KAMIMURA

  $Id$
*/

#include <string>
#include <vector>

class ConnectionInterface;


/*!
  \brief ZTEC^[tF[X
*/
class RangeSensorInterface {
public:
  virtual ~RangeSensorInterface(void) {}

  /*!
    \brief ԂԂ

    \return Ԃ

    gp
    \code
UrgCtrl sensor;
if (! sensor.connect(device, baudrate)) {
  printf("connect: %s\n", sensor.what());
  exit(1);
}
    \endcode
  */
  virtual const char* what(void) = 0;

  /*!
    \brief ڑ

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g

    \retval true ڑ
    \retval false ڑɎs

    gp
    \code
const char device[] = "/dev/ttyACM0";
const long baudrate = 115200;
UrgCtrl sensor;
if (! sensor.connect(device, baudrate)) {
  printf("connect: %s\n", sensor.what());
  exit(1);
}
    \endcode
  */
  virtual bool connect(const char* device, long baudrate) = 0;

  /*!
    \brief ڑ

    \param con [i] ڑIuWFNg

    \retval true ڑ
    \retval false ڑɎs
  */
  virtual bool connect(ConnectionInterface* con) = 0;

  /*!
    \brief ؒf
  */
  virtual void disconnect(void) = 0;

  /*!
    \brief ڑԂԂ

    \retval true ڑ
    \retval false ؒf
  */
  virtual bool isConnected(void) = 0;

  /*!
    \brief o[W̎擾

    \param lines [o] o[W

    \retval true I
    \retval false ̎擾Ɏs

    gp
    \code
UrgCtrl sensor;
if (! sensor.connect(device)) {
  ...
}
...

std::vector<std::string> lines;
if (sensor.getVersionInfo(lines)) {
  for (std::vector<std::string> >::iterator it = lines.begin();
       it != lines.end(); ++it) {
    std::cout << *it << std::endl;
  }
}
    \endcode
  */
  virtual bool getVersionInfo(std::vector<std::string>& lines) = 0;

  /*!
    \brief L̍ŏl擾

    \return L̍ŏl
  */
  virtual long getMinDistance(void) const = 0;

  /*!
    \brief L̍ől擾

    \return L̍ől
  */
  virtual long getMaxDistance(void) const = 0;

  /*!
    \brief PXL̍őf[^TCYԂ

    \return PXL̍őf[^TCY
  */
  virtual int getMaxDataLength(void) const = 0;

  virtual int capture(long data[], size_t max_size) = 0;

  /*!
    \brief f[^CfbNX̃WApxϊ

    \param index [i] f[^CfbNX

    \return WApx

    ZTOʂA0.0 [rad] ɑB

    \image html sensor_radian.png ZTʂ̊pxΉ}
  */
  virtual double index2rad(const int index) const = 0;

  /*!
    \brief WApx̃f[^CfbNXϊ

    \param radian [i] WApx

    \return f[^CfbNX

    ZTOʂA0.0 [rad] ɑB

    \image html sensor_radian.png ZTʂ̊pxΉ}
  */
  virtual int rad2index(const double radian) const = 0;
};

#endif /* !RANGE_SENSOR_INTERFACE_H */
