#ifndef LOCK_GUARD_H
#define LOCK_GUARD_H

/*!
  \file
  \brief SDL_mutex ̃bNK[hNX

  \author Satofumi KAMIMURA

  $Id$
*/

#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL.h>
#endif
#include <memory>


/*!
  \brief SDL_mutex ̃bNK[hNX
*/
class LockGuard {
  LockGuard(void);
  LockGuard(const LockGuard& rhs);
  LockGuard& operator = (const LockGuard& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  explicit LockGuard(SDL_mutex* mutex);
  ~LockGuard(void);
};

#endif /* !LOCK_GUARD_H */
