#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG 

  \author Satofumi KAMIMURA

  $Id$

  \todo Manual, Auto \bhŕύX\ł
*/

#include "RangeSensorInterface.h"
#include <memory>

class ConnectionInterface;
class SensorParameter;


/*!
  \brief SCIP2.0 Kiɂ URG 
*/
class UrgCtrl : public RangeSensorInterface {
  UrgCtrl(const UrgCtrl& rhs);
  UrgCtrl& operator = (const UrgCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum {
    NotConnected = -1,
    DefaultBaudrate = 115200,

    Infinity = -1,

    VEND = 0,			// x_
    PROD,			// i
    FIRM,			// t@[EFAo[W
    PROT,			// vgRo[W
    SERI,			// ZTŗLVAԍ
  };

  typedef enum {
    ManualCapture,
    AutoCapture,
  } CaptureMode;

  UrgCtrl(void);
  ~UrgCtrl(void);
  const char* what(void);

  bool connect(int argc, char* argv[]);
  bool connect(const char* device, long baudrate = DefaultBaudrate);
  bool connect(ConnectionInterface* con);
  void disconnect(void);
  bool isConnected(void);
  bool getVersionInfo(std::vector<std::string>& lines);
  bool loadSensorParameter(SensorParameter* parameter);
  void setSensorParameter(const SensorParameter* parameter);

  void setHandstand(bool on = true);

  /*!
    \brief 擾[h̐ݒ

    \param mode [i] 擾[hݒ (AutoCapture / ManualCapture)

    \code
UrgCtrl urg;
urg.setCaptureMode(UrgCtrl::AutoCapture);
    \endcode

    擾[h̏ڍׂ \ref compare_auto_manual_page QƂ̂ƁB
  */
  void setCaptureMode(CaptureMode mode);

  // f[^擾̊Jn
  void startCaptures(void);

  void stopCaptures(void);

  // f[^擾
  int capture(long data[], size_t max_size);

  // 擾obt@̐ݒ
  void setMaxBufferNum(size_t size);

  // O capture() ̃^CX^vԂ
  unsigned long getTimestamp(void);

  // t[̊Ԉ
  void setFrameSkipFrames(size_t skip_frames);

  // f[^܂Ƃ߂O[v
  void setDataGroups(size_t groups);

  // 擾͈͂̎w
  void setCaptureRange(int first_index, int last_index);

  // ŒZ苗̎擾
  long getMinDistance(void) const;

  // Œ苗̎擾
  long getMaxDistance(void) const;

  // őf[^TCY̎擾
  int getMaxDataLength(void) const;

  // [Ȕo͐
  void setLaserOutput(bool on);

  // pxϊ
  double index2rad(const int index) const;
  int rad2index(const double radian) const;
};

#endif /* !URG_CTRL_H */
