/*!
  \file
  \brief WII WCXeBbN

  \author Satofumi KAMIMURA

  $Id$

  wmgui ̎Qlɂ܂B

  \attention Ƃ肠APڑł΂悢Ƃɂ
  \todo vector<bool> ܂悭Ȃ΁AC
*/

#include "WiiJoystick.h"
#include "wiimote.h"
#include "MathUtils.h"
#include "LockGuard.h"
#include <SDL.h>
#include <string>
#include <vector>


/*!
  \brief WiiJoystick ̓NX
*/
struct WiiJoystick::pImpl {

  std::string error_message;
  wiimote_t* wiimote;
  bdaddr_t bdaddr;
  int wii_id;

  /*!
    \brief Wii ̊Ǘ
  */
  class WiiInfo {
  public:
    enum {
      AxisNum = 2,
      ButtonsNum = 7,
    };
    SDL_mutex* mutex;
    int battery_percent;
    std::vector<short> axis_value;
    std::vector<bool> button_value;
    Grid3D<unsigned char> acc_zero;
    Grid3D<unsigned char> acc_one;
    Grid3D<unsigned char> pos;
    bool acc_initialized;

    WiiInfo(void)
      : mutex(SDL_CreateMutex()), battery_percent(-1), acc_initialized(false) {
      for (int i = 0; i < AxisNum; ++i) {
	axis_value.push_back(0);
      }
      for (int i = 0; i < ButtonsNum; ++i) {
	button_value.push_back(false);
      }
    }

    ~WiiInfo(void) {
      SDL_DestroyMutex(mutex);
    }
  };
  static WiiInfo wii_info;

  pImpl(void)
    : error_message("no error."), wiimote(NULL), bdaddr(*BDADDR_ANY),
      wii_id(-1) {
  }

  ~pImpl(void) {
    disconnect();
  }

  void disconnect(void) {
    if (wiimote) {
      wiimote_disconnect(wiimote);
      wiimote = NULL;
      error_message = "no connection.";
    }
  }

  static void wiimote_acc(struct wiimote_acc_mesg *mesg) {

    LockGuard guard(pImpl::wii_info.mutex);
    set_Grid3D<unsigned char>(&pImpl::wii_info.pos, mesg->x, mesg->y, mesg->z);
    pImpl::wii_info.acc_initialized = true;
  }


  static void wiimote_btn(struct wiimote_btn_mesg *mesg) {

    LockGuard guard(pImpl::wii_info.mutex);

    // E
    short axis_value = 0;
    if (mesg->buttons & WIIMOTE_BTN_LEFT) {
      axis_value = -32767;
    } else if (mesg->buttons & WIIMOTE_BTN_RIGHT) {
      axis_value = +32767;
    }
    pImpl::wii_info.axis_value[0] = axis_value;

    // ㉺
    axis_value = 0;
    if (mesg->buttons & WIIMOTE_BTN_UP) {
      axis_value = -32767;
    } else if (mesg->buttons & WIIMOTE_BTN_DOWN) {
      axis_value = +32767;
    }
    pImpl::wii_info.axis_value[1] = axis_value;

    // {^
    pImpl::wii_info.button_value[Button_A] =
      (mesg->buttons & WIIMOTE_BTN_A) ? true : false;
    pImpl::wii_info.button_value[Button_B] =
      (mesg->buttons & WIIMOTE_BTN_B) ? true : false;
    pImpl::wii_info.button_value[Button_Minus] =
      (mesg->buttons & WIIMOTE_BTN_MINUS) ? true : false;
    pImpl::wii_info.button_value[Button_Plus] =
      (mesg->buttons & WIIMOTE_BTN_PLUS) ? true : false;
    pImpl::wii_info.button_value[Button_Home] =
      (mesg->buttons & WIIMOTE_BTN_HOME) ? true : false;
    pImpl::wii_info.button_value[Button_1] =
      (mesg->buttons & WIIMOTE_BTN_1) ? true : false;
    pImpl::wii_info.button_value[Button_2] =
      (mesg->buttons & WIIMOTE_BTN_2) ? true : false;
  }

  static void wiimote_callback(int id, int mesg_count,
			       union wiimote_mesg *mesg_array[]) {

    LockGuard guard(pImpl::wii_info.mutex);

    for (int i = 0; i < mesg_count; ++i) {
      switch (mesg_array[i]->type) {
      case WIIMOTE_MESG_STATUS:
	pImpl::wii_info.battery_percent =
	  static_cast<int>(100.0 * mesg_array[i]->status_mesg.battery /
			   WIIMOTE_BATTERY_MAX);
	break;

      case WIIMOTE_MESG_BTN:
	wiimote_btn(&mesg_array[i]->btn_mesg);
	break;

      case WIIMOTE_MESG_ACC:
	wiimote_acc(&mesg_array[i]->acc_mesg);
	break;

      case WIIMOTE_MESG_IR:
	//wiimote_ir(&mesg_array[i]->ir_mesg);
	break;

      case WIIMOTE_MESG_NUNCHUK:
	//wiimote_nunchuk(&mesg_array[i]->nunchuk_mesg);
	break;

      case WIIMOTE_MESG_CLASSIC:
	//wiimote_classic(&mesg_array[i]->classic_mesg);
	break;

      case WIIMOTE_MESG_ERROR:
	//menuDisconnect_activate();
	break;

      default:
	break;
      }
    }
  }
};

WiiJoystick::pImpl::WiiInfo WiiJoystick::pImpl::wii_info;


WiiJoystick::WiiJoystick(void) : pimpl(new pImpl) {
}


WiiJoystick::~WiiJoystick(void) {
}


const char* WiiJoystick::what(void) {
  return pimpl->error_message.c_str();
}


bool WiiJoystick::connect(void) {

  pimpl->wiimote = wiimote_connect(&pimpl->bdaddr, pImpl::wiimote_callback,
				   NULL); //&pimpl->wii_id);
  if (pimpl->wiimote == NULL) {
    pimpl->error_message = "connection fail.";
    return false;
  }

  // Lu[V
  accelerationCalibration();

  return true;
}


void WiiJoystick::disconnect(void) {
  pimpl->disconnect();
}


bool WiiJoystick::isConnected(void) {
  return (pimpl->wiimote == NULL) ? false : true;
}


const char* WiiJoystick::getProductInfo(void) {

  // !!! ɑΉAID ԍK؂ɏ邱
  return "wii remote controller 0";
}


size_t WiiJoystick::getNumAxis(void) {
  return pImpl::WiiInfo::AxisNum;
}


size_t WiiJoystick::getNumButtons(void) {

  /*
    0: "A"
    1: "B"
    2: "-"
    3: "+"
    4: "home"
    5: "1"
    6: "2"
  */
  return pImpl::WiiInfo::ButtonsNum;
}


short WiiJoystick::getAxisValue(size_t index) {

  LockGuard guard(pImpl::wii_info.mutex);
  return pImpl::wii_info.axis_value[index];
}


bool WiiJoystick::isButtonPressed(size_t index) {

  LockGuard guard(pImpl::wii_info.mutex);
  return pImpl::wii_info.button_value[index];
}


void WiiJoystick::setEvent(SDL_Event& event) {
  // Dummy
}


int WiiJoystick::getBatteryPercent(void) {

  LockGuard guard(pImpl::wii_info.mutex);
  return pImpl::wii_info.battery_percent;
}


void WiiJoystick::setLed(unsigned char pattern) {

  uint8_t led_state =
    ((pattern & 0x8) ? WIIMOTE_LED1_ON : 0) |
    ((pattern & 0x4) ? WIIMOTE_LED2_ON : 0) |
    ((pattern & 0x2) ? WIIMOTE_LED3_ON : 0) |
    ((pattern & 0x1) ? WIIMOTE_LED4_ON : 0);

  if (wiimote_command(pimpl->wiimote, WIIMOTE_CMD_LED, led_state)) {
    pimpl->error_message = "fail setting LEDs";
  }
}


bool WiiJoystick::getRawAccelerations(Grid3D<unsigned char>& acc,
				      Grid3D<unsigned char>& acc_zero,
				      Grid3D<unsigned char>& acc_one) {
  acc = pImpl::wii_info.pos;
  acc_zero = pImpl::wii_info.acc_zero;
  acc_one = pImpl::wii_info.acc_one;

  return pImpl::wii_info.acc_initialized;
}


void WiiJoystick::setRawAccelerations(Grid3D<unsigned char>& acc,
				      Grid3D<unsigned char>& acc_zero,
				      Grid3D<unsigned char>& acc_one) {

  pImpl::wii_info.pos = acc;
  pImpl::wii_info.acc_zero = acc_zero;
  pImpl::wii_info.acc_one = acc_one;
}


void WiiJoystick::getAccelerations(double* a_x, double* a_y, double* a_z,
				   double* roll, double* pitch) {

  LockGuard guard(pImpl::wii_info.mutex);

  Grid3D<unsigned char>& acc_zero = pImpl::wii_info.acc_zero;
  Grid3D<unsigned char>& acc_one = pImpl::wii_info.acc_one;
  Grid3D<unsigned char>& pos = pImpl::wii_info.pos;

  // !!! [Z͔Ȃ̂ȁH
  *a_x = (static_cast<double>(pos.x) - acc_zero.x) / (acc_one.x - acc_zero.x);
  *a_y = (static_cast<double>(pos.y) - acc_zero.y) / (acc_one.y - acc_zero.y);
  *a_z = (static_cast<double>(pos.z) - acc_zero.z) / (acc_one.z - acc_zero.z);

  double roll_value = atan(*a_x / *a_z);
  if (*a_z <= 0.0) {
    roll_value += M_PI * ((*a_x > 0.0) ? 1 : -1);
  }
  roll_value *= -1;
  double pitch_value = atan(*a_y / *a_z * cos(roll_value));

  if (roll != NULL) {
    *roll = roll_value;
  }
  if (pitch != NULL) {
    *pitch = pitch_value;
  }
}


void WiiJoystick::accelerationCalibration(void) {

  LockGuard guard(pImpl::wii_info.mutex);

  unsigned char buf[7];
  if (wiimote_read(pimpl->wiimote, WIIMOTE_RW_EEPROM, 0x16, 7, buf)) {
    pimpl->error_message = "Unable to retrieve accelerometer";

  } else {
    set_Grid3D<unsigned char>(&pImpl::wii_info.acc_zero,
			      buf[0], buf[1], buf[2]);
    set_Grid3D<unsigned char>(&pImpl::wii_info.acc_one,
			      buf[4], buf[5], buf[6]);
  }

  // JԂ擾̍Đݒ
  uint8_t rpt_mode =
    WIIMOTE_RPT_STATUS | WIIMOTE_RPT_BTN | WIIMOTE_RPT_ACC | WIIMOTE_RPT_IR;
  wiimote_command(pimpl->wiimote, WIIMOTE_CMD_RPT_MODE, rpt_mode);
  // !!! ȉ̃R}h{ɕKv́As
  wiimote_command(pimpl->wiimote, WIIMOTE_CMD_STATUS, 0);
}
