/*!
  \file
  \brief NMEA nh

  \author Satofumi KAMIMURA

  $Id$

  http://www.enri.go.jp/~fks442/K_MUSEN/ ̃vO𗘗p

  \todo hhmmss.ss  msec 荞
  \todo xNgZNX`Ēu
  \todo getLength(), getGrid3D() ́Astatic o֐ɒu
*/

#include "NmeaHandler.h"
#include "NmeaState.h"
#include "MathUtils.h"
#include <string>
#include <vector>

#include "str01.h"
extern vector ecef2enu(vector dest, vector origin);
extern vector blh2ecef(double phi, double ramda, double height);


struct NmeaHandler::pImpl {
  static const double GpsPi = 3.1415926535898;
  std::string error_message;

  pImpl(void) : error_message("no error.") {
  }

  bool isLf(const char ch) {
    return ((ch == '\r') || (ch == '\n')) ? true : false;
  }

  bool checkSum(const char* line, size_t length) {
    if (length < 3) {
      return false;
    }

    char expected = strtol(&line[length - 2], NULL, 16);
    char sum = 0;
    for (size_t i = 1; i < length -2 -1; ++i) {
      sum ^= line[i];
    }
    if (sum != expected) {
      return false;
    }
    return true;
  }

  size_t splitString(std::vector<std::string>& split_lines,
		     const char* line,
		     const char split_tag = ',') {
    split_lines.clear();
    std::string parse_line = line;
    size_t first = 0;

    while (1) {
      size_t last = parse_line.find(split_tag, first);
      if (last == std::string::npos) {
	split_lines.push_back(parse_line.substr(first));
	break;
      }
      split_lines.push_back(parse_line.substr(first, last - first));
      first = last +1;
    }
    return split_lines.size();
  }

  void parseGga(NmeaState* state, const char* line) {

    std::vector<std::string> split_lines;
    size_t n = splitString(split_lines, line);

    double latitude = 0.0;
    double longitude = 0.0;
    for (size_t i = 0; i < n; ++i) {
      std::string& each_line = split_lines[i];
      if (i == 0) {
	// $GPGGGA

      } else if (i == 1) {
	// hhmmss
	if (each_line.size() < 6) {
	  continue;
	}
	state->hour = atoi(each_line.substr(0, 2).c_str());
	state->minute = atoi(each_line.substr(2, 2).c_str());
	state->second = atoi(each_line.substr(4, 2).c_str());

      } else if (i == 2) {
	// ddmm.mmmm
	size_t period_pos = each_line.find('.');
	if ((period_pos == std::string::npos) ||
	    (period_pos < 2)) {
	  continue;
	}
	latitude = atoi(each_line.substr(0, period_pos - 2).c_str())
	  + (atof(each_line.substr(period_pos - 2).c_str()) / 60.0);

      } else if (i == 3) {
	// N
	state->latitude = (each_line[0] == 'N') ? latitude : -latitude;

      } else if (i == 4) {
	// ddmm.mmmm
	size_t period_pos = each_line.find('.');
	if ((period_pos == std::string::npos) ||
	    (period_pos < 2)) {
	  continue;
	}
	longitude = atoi(each_line.substr(0, period_pos - 2).c_str())
	  + (atof(each_line.substr(period_pos - 2).c_str()) / 60.0);

      } else if (i == 5) {
	// E
	state->longitude = (each_line[0] == 'E') ? longitude : -longitude;

      } else if (i == 6) {
	// n
	int value = atoi(each_line.c_str());
	if (value == 0) {
	  state->mode = NmeaState::None;
	} else if (value == 1) {
	  state->mode = NmeaState::Normal;
	} else if (value == 2) {
	  state->mode = NmeaState::DGPS;
	}

      } else if (i == 7) {
	// mm
	state->satelites = atoi(each_line.c_str());

      } else if (i == 8) {
	// nn.n
	// !!!

      } else if (i == 9) {
	// xnnnn.n
	state->altitude = atof(each_line.c_str());
      }
    }
  }

  void parseRmc(NmeaState* state, const char* line) {
    std::vector<std::string> split_lines;
    size_t n = splitString(split_lines, line);

    for (size_t i = 0; i < n; ++i) {
      std::string& each_line = split_lines[i];
      if (i == 0) {
	// $GPRMC

      } else if (i == 1) {
	// hhmmss
	// !!!

      } else if (i == 2) {
	// x
	// !!!

      } else if (i == 3) {
	// ddmm.mmmm
	// !!!

      } else if (i == 4) {
	// N
	// !!!

      } else if (i == 5) {
	// ddmm.mmmm
	// !!!

      } else if (i == 6) {
	// E
	// !!!

      } else if (i == 7) {
	// nnn.n
	state->velocity = atof(each_line.c_str()) * 500.0 / 971.9;

      } else if (i == 8) {
	// ddd.d
	state->direction = atof(each_line.c_str());

      } else if (i == 9) {
	// ddmmyy
	//fprintf(stderr, "%s\n", each_line.c_str());
	state->day = atoi(each_line.substr(0, 2).c_str());
	state->month = atoi(each_line.substr(2, 2).c_str());
	state->year = 2000 + atoi(each_line.substr(4, 2).c_str());

	// !!!

      } else if (i == 10) {
	// a
	// !!!
      }
    }
  }

#if 0
  void calcEcef(Grid3D<double>* position, const NmeaState* state) {
    // !!!
  }
#endif

  static void calcGrid3D(Grid3D<double>* grid,
			 const NmeaState* point_state,
			 const NmeaState* origin_state) {

    vector origin_ecef = blh2ecef(origin_state->latitude,
				  origin_state->longitude,
				  origin_state->altitude);

    vector point_ecef = blh2ecef(point_state->latitude,
				 point_state->longitude,
				 point_state->altitude);
    vector enu = ecef2enu(point_ecef, origin_ecef);

    grid->x = enu.a[0];
    grid->y = enu.a[1];
    grid->z = enu.a[2];
  }
};


NmeaHandler::NmeaHandler(void) : pimpl(new pImpl) {
}


NmeaHandler::~NmeaHandler(void) {
}


const char* NmeaHandler::what(void) {
  return pimpl->error_message.c_str();
}


bool NmeaHandler::updateState(NmeaState* state, const char* line) {

  int length = strlen(line);
  while (length > 0) {
    if (! pimpl->isLf(line[length -1])) {
      break;
    }
    --length;
  }

  // `FbNT̊mF
  if (! pimpl->checkSum(line, length)) {
    pimpl->error_message = "invalid checksum.";
    return false;
  }

  if (length < 6) {
    pimpl->error_message = "invalid format.";
    return false;

  } else if (! strncmp("$GPGGA", line, 6)) {
    pimpl->parseGga(state, line);

  } else if (! strncmp("$GPRMC", line, 6)) {
    pimpl->parseRmc(state, line);

  } else {
    pimpl->error_message = "not implemented NMEA format.";
    return false;
  }
  return true;
}


void NmeaHandler::getGrid3D(Grid3D<double>* position,
			    const NmeaState* point, const NmeaState* origin) {

  Grid3D<double> grid;
  pImpl::calcGrid3D(&grid, point, origin);

  position->x = grid.x;
  position->y = grid.y;
  position->z = grid.z;
}


double NmeaHandler::getLength(const NmeaState* point,
			      const NmeaState* origin) {

  Grid3D<double> grid;
  pImpl::calcGrid3D(&grid, point, origin);

  double x = grid.x;
  double y = grid.y;
  double z = grid.z;

  return sqrt(x*x + y*y + z*z);
}
