#ifndef GPS_LOG_READER_H
#define GPS_LOG_READER_H

/*!
  \file
  \brief GPS O̓ǂݏoNX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "GpsInterface.h"
#include <memory>


/*!
  \brief GPS Ȍ擾NX
*/
class GpsLogReader : public GpsInterface {
  GpsLogReader(const GpsLogReader& rhs);
  GpsLogReader& operator = (const GpsLogReader& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  GpsLogReader(void);
  ~GpsLogReader(void);

  const char* what();
  bool updateState(NmeaState* state, std::string& line);
  int getInvalidPeriod(void);

  bool connect(const char* logfile);
  bool play(const size_t total_msec);
};

#endif /* !GPS_LOG_READER_H */
