/*!
  \file
  \brief GPS ȌNX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "GpsLogReader.h"
#include "NmeaHandler.h"
#include "NmeaState.h"
#include <string.h>
#include <errno.h>
#include <fstream>
#include <deque>


/*!
  \brief GpsLogReader ̓NX
*/
struct GpsLogReader::pImpl {
  enum { InvalidMsec = 0 };
  std::string error_message;
  std::ifstream fin;
  NmeaHandler nmea;
  NmeaState last_state;
  size_t first_msec;
  size_t spent_msec;

  typedef struct {
    NmeaState state;
    std::string line;
    bool updated;
  } PlayedState;
  typedef std::deque<PlayedState> PlayedDeque;
  PlayedDeque played_deque;

  pImpl(void)
    : error_message("no error."), first_msec(InvalidMsec), spent_msec(0) {
  }

  size_t getMsec(const NmeaState* state) {

    struct tm times;
    times.tm_sec = state->second;
    times.tm_min = state->minute;
    times.tm_hour = state->hour;
    times.tm_mday = (state->day > 0) ? state->day : 1;
    times.tm_mon = (state->month > 0) ? state->month -1 : 0;
    times.tm_year = (state->year > 0) ? state->year - 1900 : 2000 - 1900;
    times.tm_isdst = 0;

    time_t now_time = mktime(&times);
    return (now_time < 0) ? 0 : (now_time * 1000);
  }

  bool play(const size_t total_msec) {
    if (! fin.is_open()) {
      return false;
    }
    if (total_msec < spent_msec) {
      return true;
    }

    // total_msec ԂZf[^AupdateState() pɕێ
    while (! fin.eof()) {

      PlayedState played_state;
      getline(fin, played_state.line);

      played_state.updated = nmea.updateState(&last_state,
					      played_state.line.c_str());
      played_state.state = last_state;
      played_deque.push_back(played_state);

      size_t now_msec = getMsec(&last_state);
      spent_msec = now_msec - first_msec;
      if (spent_msec > total_msec) {
	// w莞ԕ̃f[^ǂݏoI
	return true;
      }
    }
    return false;
  }
};


GpsLogReader::GpsLogReader(void) : pimpl(new pImpl) {
}


GpsLogReader::~GpsLogReader(void) {
}


const char* GpsLogReader::what() {
  return pimpl->error_message.c_str();
}


bool GpsLogReader::updateState(NmeaState* state, std::string& line) {

  // deque Ɋi[ play() ςݓe state, line, updated Ԃ
  if (pimpl->played_deque.empty()) {
    return false;
  }
  pImpl::PlayedState last_state = pimpl->played_deque.front();
  pimpl->played_deque.pop_front();

  *state = last_state.state;
  line = last_state.line;
  return last_state.updated;
}


int GpsLogReader::getInvalidPeriod(void) {

  // !!!
  // !!! ǂׂȁH
  return 0;
}


bool GpsLogReader::connect(const char* logfile) {

  pimpl->fin.open(logfile);
  if (! pimpl->fin.is_open()) {
    pimpl->error_message = strerror(errno);
    return false;
  }

  // Qb̃f[^ǂݏoBNȀ擾邽
  for (int i = 0; i < 2; ++i) {
    size_t first_msec = pimpl->getMsec(&pimpl->last_state);
    while (! pimpl->fin.eof()) {
      std::string line;
      getline(pimpl->fin, line);
      pimpl->nmea.updateState(&pimpl->last_state, line.c_str());

      size_t now_msec = pimpl->getMsec(&pimpl->last_state);
      if (first_msec != now_msec) {
	pimpl->first_msec = now_msec;
	break;
      }
    }
  }
  return true;
}


bool GpsLogReader::play(const size_t total_msec) {
  return pimpl->play(total_msec);
}
