#ifndef CONNECTION_LOGGER_H
#define CONNECTION_LOGGER_H

/*!
  \file
  \brief ʐM̋L^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionInterface.h"
#include <SDL_net.h>
#include <memory>

class SocketSet;


/*!
  \brief Mf[^̋L^NX
*/
class ConnectionLogger : public ConnectionInterface {
  ConnectionLogger(void);
  ConnectionLogger(const ConnectionLogger& rhs);
  ConnectionLogger& operator = (const ConnectionLogger& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  ConnectionLogger(ConnectionInterface* con);
  ~ConnectionLogger(void);

  const char* what(void);
  int connect(const char* host, long port);
  void disconnect(void);
  bool isConnected(void);
  int changeBaudrate(long baudrate);
  int send(const char* data, int size);
  int recv(char* data, int size, int timeout);
  int size(int timeout = 0);
  void clear(void);
  void skip(int timeout);

  /*!
    \brief Ȍo̓t@Cݒ

    \param logfileName [i] Ȍo̓t@C
  */
  void setLogfileName(const char* logfileName);
};

#endif /* !CONNECTION_LOGGER_H */
