/*!
  \file
  \brief W͂̎M

  \author Satofumi KAMIMURA

  $Id$
*/

#include "StandardInput.h"
#include <sys/poll.h>


/*!
  \brief StandardInput ̓NX
*/
struct StandardInput::pImpl {
  struct pollfd nfds;           /*!< ^CAEg */

  pImpl(void) {
    nfds.fd = 0;
    nfds.events = POLLIN | POLLPRI | POLLERR | POLLHUP | POLLNVAL;
    nfds.revents = 0;
  }
};


StandardInput::StandardInput(void) : pimpl(new pImpl) {
}


StandardInput::~StandardInput(void) {
}


int StandardInput::recv(char *buffer, size_t maxlen, int timeout) {
  size_t filled = 0;

  while (filled < maxlen) {
    if (poll(&pimpl->nfds, 1, timeout) == 0) {
      break;                    // timeout
    }

    int n = read(0, &buffer[filled], maxlen - filled);
    if (n < 0) {
      return filled;
    }
    filled += n;
  }
  return filled;
}
