/*!
  \example
  \brief p[^\Tv

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include "SensorParameter.h"


int main(int argc, char *argv[]) {

  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  SensorParameter param;
  if (! urg.loadSensorParameter(&param)) {
    printf("UrgCtrl::loadSensorParameter: %s\n", urg.what());
    exit(1);
  }

  printf("MODL: %s\n", param.model.c_str());
  printf("DMIN: %ld\n", param.distance_min);
  printf("DMAX: %ld\n", param.distance_max);
  printf("ARES: %d\n", param.area_total);
  printf("AMIN: %d\n", param.area_min);
  printf("AMAX: %d\n", param.area_max);
  printf("AFRT: %d\n", param.area_front);
  printf("SCAN: %d\n", param.scan_rpm);

  return 0;
}
