/*!
  \example
  \brief P̃XL

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"


int main(int argc, char *argv[]) {

  const char*const device = "/dev/ttyACM0";
  const long baudrate = 115200;

  UrgCtrl urg;
  if (! urg.connect(device, baudrate)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  size_t data_max = urg.getMaxDataLength();
  printf("data_max = %d\n", urg.getMaxDataLength());
  long* data = new long[data_max];

  // f[^\
  int n = urg.capture(data, data_max);
  printf("n = %d\n", n);
  if (n < 0) {
    printf("%s\n", urg.what());
  }
  for (int i = 0; i < n; ++i) {
    printf("%ld,", data[i]);
  }
  printf("\n");
  delete [] data;

  urg.disconnect();
  return 0;
}
