/*!
  \file
  \brief Joystick ̕\

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ViewJoystickInfo.h"
#include "JoystickInterface.h"
#include "Delay.h"
#include "SdlInit.h"
#include <stdio.h>


/*!
  \brief SdlInit ̏NX
*/
class SdlInitClass : private SdlInit {
};


static bool printJoystickInput(JoystickInterface& joystick,
			       size_t axis_num, size_t buttons_num) {

  bool haveInput = false;

  for (size_t i = 0; i < axis_num; ++i) {
    short value = joystick.getAxisValue(i);
    printf("%d,", value);
    if (value != 0) {
      haveInput = true;
    }
  }

  for (size_t i = 0; i < buttons_num; ++i) {
    bool pressed = joystick.isButtonPressed(i);
    printf("%c,", (pressed) ? '*' : '_');
    if (pressed != false) {
      haveInput = true;
    }
  }
  putchar('\n');

  return haveInput;
}


void ViewJoystickInfo(JoystickInterface& joystick) {
  static SdlInitClass obj;

  size_t axis_num = joystick.getNumAxis();
  size_t buttons_num = joystick.getNumButtons();

  // ͏̏o
  Uint32 lastInputTicks = SDL_GetTicks();
  while (1) {
    // TbȏA{^͂ȂΏI
    if (SDL_GetTicks() - lastInputTicks > 5000) {
      break;
    }

    // WCXeBbNւ̓͏\
    SDL_Event event;
    while (SDL_PollEvent(&event)) {
      joystick.setEvent(event);
    }
    if (printJoystickInput(joystick, axis_num, buttons_num)) {
      lastInputTicks = SDL_GetTicks();
    }

    // ͂\
    delay(200);
  }
}
