/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.beangenerator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import nu.mine.kino.plugin.beangenerator.Activator;
import nu.mine.kino.plugin.beangenerator.JavaBeansCreator;
import nu.mine.kino.plugin.beangenerator.JavaBeansReaderCreator;
import nu.mine.kino.plugin.beangenerator.Messages;
import nu.mine.kino.plugin.beangenerator.sheetdata.IClassInformation;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;

public class JavaBeansCreatorWithProgress
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(JavaBeansCreatorWithProgress.class);
    private IStructuredSelection ss;
    private List<ICompilationUnit> list = new ArrayList<ICompilationUnit>();
    private IWorkbenchSite site;
    private final IAction action;

    public JavaBeansCreatorWithProgress(IStructuredSelection ss, IWorkbenchSite site, IAction action) {
        this.ss = ss;
        this.site = site;
        this.action = action;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        logger.debug((Object)"run(IProgressMonitor) - start");
        int totalWork = this.ss.size() * 2;
        monitor.beginTask(Messages.JavaBeansCreatorWithProgress_MSG_BEGIN_TASK, totalWork);
        try {
            for (IFile file : this.ss) {
                IProject project = file.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                monitor.subTask(String.valueOf(Messages.JavaBeansCreatorWithProgress_MSG_EXECUTE) + file.getFullPath());
                monitor.worked(1);
                List<IClassInformation> classInformations = Activator.getDefault().getClassInformations(file);
                for (IClassInformation classInformation : classInformations) {
                    logger.debug((Object)classInformation);
                    monitor.subTask(String.valueOf(Messages.JavaBeansCreatorWithProgress_MSG_EXECUTE) + classInformation.getClassNameJ());
                    ICompilationUnit cu = null;
                    cu = this.action.getId().equals("nu.mine.kino.plugin.beangenerator.actions.JavaBeansReaderGeneratorAction") ? new JavaBeansReaderCreator(javaProject).create(classInformation) : new JavaBeansCreator(javaProject).create(classInformation);
                    if (cu != null) {
                        this.list.add(cu);
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new InterruptedException("Cancel has been requested.");
                }
                monitor.worked(1);
            }
        }
        catch (CoreException e1) {
            throw new InvocationTargetException(e1);
        }
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                Object[] units = JavaBeansCreatorWithProgress.this.list.toArray(new ICompilationUnit[JavaBeansCreatorWithProgress.this.list.size()]);
                OrganizeImportsAction importsAction = new OrganizeImportsAction(JavaBeansCreatorWithProgress.this.site);
                FormatAllAction formatAllAction = new FormatAllAction(JavaBeansCreatorWithProgress.this.site);
                StructuredSelection selection = new StructuredSelection(units);
                importsAction.run((IStructuredSelection)selection);
                formatAllAction.run((IStructuredSelection)selection);
            }
        });
        monitor.worked(totalWork);
        monitor.done();
        logger.debug((Object)"run(IProgressMonitor) - end");
    }
}

