package ams.com.ams.beanql.test.other;

import java.sql.SQLException;
import java.util.Collection;

import ams.com.ams.beanql.BeanQLManager;
import ams.com.ams.beanql.BeanQLStatement;
import ams.com.ams.beanql.BeanQLTransaction;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLTableNotFoundException;
import ams.com.ams.beanql.test.BeanDebug;

/**
 * <p>タイトル: BeanQLStatement_test001</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2003 AMsoft</p>
 * <p>会社名: </p>
 * <p>Created on 2003/10/07</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class BeanQLStatement_test001 {

	/**
	 * コンストラクタ
	 */
	public BeanQLStatement_test001() {
		super();
	}

	public static void main(String[] args) throws SQLException, BeanQLException, BeanQLTableNotFoundException {
		BeanQLManager bm = new BeanQLManager(
			"org.gjt.mm.mysql.Driver",
			"jdbc:mysql://localhost:3306/ae1?useUnicode=true&characterEncoding=SJIS",
			"mysql", "mysql", BeanQLManager.VENDOR_MYSQL, "BEANQL_SEQUENCE");
			
		BeanQLTransaction bt = bm.getBeanQLTransaction();
		bt.setAutoCommit(true);
		//bt.commit();
		//bt.rollback();
		
		BeanQLStatement bs = bt.createStatement(BeanQL_TestUsers.class);
		
		Collection col = bs.selectAll();	
		BeanDebug.printCollection(col);

		// select test	
		col = bs.select("users_id Like '%user'");
		BeanDebug.printCollection(col);
		
		col = bs.select("user_name Like '%am%'", "users_id ASC"); // where groupby
		BeanDebug.printCollection(col);
		
		col = bs.select("user_name Like '%王%'", "users_id", "users_id ASC"); // where groupby orderby
		BeanDebug.printCollection(col);
		
		// insert test
		BeanQL_TestUsers in_users = new BeanQL_TestUsers();
		in_users.setJdo_version("test");
		in_users.setUsers_id(5);
		in_users.setUser_name("inserted_user");
		in_users.setUser_pass("pass");
		bs.insert(in_users);
		
		// delete test
//		bs.delete("users_id = 5");

		// update test
		col = bs.select("users_id Like '%%'");
		BeanQL_TestUsers uu = (BeanQL_TestUsers)col.iterator().next();
		uu.setUser_name(uu.getUser_name() + "_");
		bs.update(uu);	// 条件無しUPDATE

	//	int c = bs.update(uu, "users_id = 5");		
		
		bs.close();
		bt.close();
	}
}
