package sample;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

import ams.com.ams.beanql.BeanQLManager;
import ams.com.ams.beanql.BeanQLStatement;
import ams.com.ams.beanql.BeanQLTransaction;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLResultEmptyException;
import ams.com.ams.beanql.exceptions.BeanQLResultMultiException;

/**
 * <p>タイトル: BeanQLSample</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2003 AMsoft</p>
 * <p>会社名: </p>
 * <p>Created on 2003/10/07</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class BeanQLSample {

	/**
	 * コンストラクタ
	 */
	public BeanQLSample() {
		super();
	}

	public static void main(String[] args) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
    
    // MySQL の場合
//		BeanQLManager bm = new BeanQLManager(
//			"org.gjt.mm.mysql.Driver",
//			"jdbc:mysql://localhost:3306/ae2?useUnicode=true&characterEncoding=SJIS",
//			"mysql", "mysql", BeanQLManager.VENDOR_MYSQL, "BEANQL_SEQUENCE");

  // oracle の場合
    BeanQLManager bm = new BeanQLManager(
      "oracle.jdbc.driver.OracleDriver",
      "jdbc:oracle:thin:@r-srv02:1521:global",
      "bermuda2", "XG7G5A83", BeanQLManager.VENDOR_ORACLE, "BEANQL_SEQUENCE");
			
		BeanQLTransaction bt = bm.getBeanQLTransaction();
		bt.setAutoCommit(true);
		
		BeanQLStatement bs = bt.createStatement(AmsTest.class);
		
    // select test  
    {
      Collection col = bs.selectAll();
      BeanDebug.printCollection(col);

      col = bs.select("name Like 'o%'");
      BeanDebug.printCollection(col);

      col = bs.select("nameID > 1", " name"); // where groupby
      BeanDebug.printCollection(col);

      col = bs.select("nameID > 1", " nameID, name", " nameID ASC"); // where groupby orderby
      BeanDebug.printCollection(col);
    }

    // insert test
    {
      AmsTest a = new AmsTest();
      a.setNameID(bs.getNextSequence());
      a.setName("test " + System.currentTimeMillis());
      try {
        bs.insert(a);
      } catch (BeanQLException e) {
        e.printStackTrace();
      } catch (SQLException e) {
        // 重複エラーなど（ベンダーによってウ異なるエラーコードから判断する）
        e.printStackTrace();
      }
    }
    
    // insert test2
    {
      AmsTest a = new AmsTest();
      a.setNameID(bs.getNextSequence());
      a.setName("test2 " + System.currentTimeMillis());
      try {
        bs.insert(a);
      } catch (BeanQLException e) {
        e.printStackTrace();
      } catch (SQLException e) {
        // 重複エラーなど（ベンダーによってウ異なるエラーコードから判断する）
        e.printStackTrace();
      }
    }
    
    // select one test
    {
      try {
        bs.selectOne("nameID = 1");
      } catch (SQLException e) {
        e.printStackTrace();
      } catch (BeanQLException e) {
        e.printStackTrace();
      } catch (BeanQLResultEmptyException e) {
        // 検索結果0件
//        e.printStackTrace();
      } catch (BeanQLResultMultiException e) {
        // 検索結果2件以上
        e.printStackTrace();
      }
    }

    
    // delete test
    {
      Collection coll = bs.selectAll();
      if (coll.size() > 0) {
        Iterator it = coll.iterator();
         bs.delete(" nameID = " + ((AmsTest)it.next()).getNameID());
      }
    }
    
    // update test
    {
      Collection coll = bs.selectAll();
      if (coll.size() > 0) {
        Iterator it = coll.iterator();
        AmsTest am = (AmsTest)it.next();
        am.setName("_" + am.getName().substring(0, 10));
        bs.update(am); // 条件無しUPDATE (IDをキーとして更新)
      }
    }
    
    // update test2
    {
      AmsTest am = (AmsTest)bs.selectOne("nameID = 1");
      am.setName("updaate test2");
      bs.update(am, "nameID = 1"); // 条件有りUPDATE
    }
    
		bs.close();
		bt.close();
	}
}
