package ams.com.ams.beanql.test.other;

import java.sql.SQLException;
import java.util.Collection;

import ams.com.ams.beanql.BeanQLManager;
import ams.com.ams.beanql.BeanQLSimpleViewStatement;
import ams.com.ams.beanql.BeanQLTransaction;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLTableNotFoundException;
import ams.com.ams.beanql.test.BeanDebug;

/**
 * <p>タイトル: BeanQLStatement_test001</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2003 AMsoft</p>
 * <p>会社名: </p>
 * <p>Created on 2003/10/07</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class BeanQLStatement_test003 {

	/**
	 * コンストラクタ
	 */
	public BeanQLStatement_test003() {
		super();
	}

	public static void main(String[] args) throws SQLException, BeanQLException, BeanQLTableNotFoundException {
		
		{
		BeanQLManager bm = new BeanQLManager(
			"org.gjt.mm.mysql.Driver",
			"jdbc:mysql://localhost:3306/ae1?useUnicode=true&characterEncoding=SJIS",
			"mysql", "mysql", BeanQLManager.VENDOR_MYSQL, "BEANQL_SEQUENCE");
			
		BeanQLTransaction bt = bm.getBeanQLTransaction();
		bt.setAutoCommit(true);
		//bt.commit();
		//bt.rollback();

		// BeanQL_TestUsers と Seibtsu クラス（テーブル）を seibetsu_id で結合し
		// 取得用クラス BeanQL_TestUsersSeibetsu
		BeanQLSimpleViewStatement bs = bt.createSimpleViewStatement(BeanQL_TestUsersSeibetsu.class);

		Collection col = bs.select("SELECT users_id, user_name, user_pass, BeanQL_TestUsers.jdo_version, seibetsu_name from BeanQL_TestUsers, Seibetsu where BeanQL_TestUsers.seibetsu_id = Seibetsu.seibetsu_id");
		BeanDebug.printCollection(col);

		
		bt.close();
		}
	}
}
