package ams.com.ams.beanql.test;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

/**
 * <p>タイトル: BeanDebug</p>
 * <p>説明: Beanデバッグクラス</p>
 * <p>著作権: Copyright (c) 2002 Orix Systems Inc, Orixrentec Inc, Lightwell Inc</p>
 * <p>会社名: (株)ライトウェル</p>
 * <p>Created on 2003/09/10</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class BeanDebug {

  /**
   * コンストラクタ
   */
  private BeanDebug() {
    super();
  }

  /**
   * print<BR>
   * Beanのプロパティを標準出力
   * @param obj Bean
   */
  public static void println(Object obj) {
    _println(obj);
  }

  /**
   * print<BR>
   * Beanのプロパティを標準出力
   * @param obj Bean
   */
  public static void print(Object obj) {
    _print(obj);
  }

  /**
   * _print<BR>
   * Beanのプロパティを標準出力
   * @param obj Bean
   */
  private static void _print(Object obj) {
    System.out.print(getBeanInfoString(obj));
  }

  /**
   * _println<BR>
   * Beanのプロパティを標準出力
   * @param obj Bean
   */
  private static void _println(Object obj) {
//    Debug.println(getBeanInfoString(obj));
    System.out.println(getBeanInfoString(obj));
  }

  /**
   * getBeanInfoString<BR>
   * Beanのプロパティを文字列で取得。
   * ArrayList のプロパティは内部までは表示しない
   * @param o Bean
   * @return 出力文字列
   */
  private static String getBeanInfoString(Object o) {
    StringBuffer buf = new StringBuffer("");

    try {
      // Beanクラス
      BeanInfo info = Introspector.getBeanInfo(o.getClass());
      PropertyDescriptor[] properties = info.getPropertyDescriptors();
      int c = 0;

      buf.append(o.getClass().getName() + "\n[");

      for (int i = 0; i < properties.length; i++) {
        Class type = properties[i].getPropertyType();
        String name = properties[i].getName();
        Method m_get = properties[i].getReadMethod();
        //      Method m_set = properties[i].getWriteMethod();
        if (m_get != null) {
          Object value = m_get.invoke(o, null);

          if (c++ > 0) {
            buf.append(",");
          }

          buf.append(value + " " + name + ":" + type.getName());
        }
      }
      buf.append("]");

    } catch (Exception e) {
      e.printStackTrace();
    }
    return buf.toString();
  }

  /**
   * printCollection<BR>
   * Collection内のBeanデータを出力
   * @param col Collection
   */
  public static void printCollection(Collection col) {
    for (Iterator it = col.iterator(); it.hasNext();) {
      println(it.next());
    }
  }

  /**
   * printArray<BR>
   * @param objects
   */
  public static void printArray(Object[] objects) {
    for(int i = 0 ;i < objects.length; i++) {
      println(objects[i]);
    }
  }
}
