package ams.com.ams.beanql;

import java.sql.SQLException;
import java.util.Collection;

import junit.framework.TestCase;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLResultEmptyException;
import ams.com.ams.beanql.exceptions.BeanQLResultMultiException;
import ams.com.ams.beanql.test.BeanDebug;
import ams.com.ams.beanql.test.BeanQLTestUtil_inJar;
import ams.com.ams.beanql.test.bean.AmsTest;

/**
 * <p>プロジェクト名: BeanQL</p>
 * <p>タイトル: BeanQLPreparedStatementTest</p>
 * <p>説明: </p>
 * <p>Created on 2003/12/17</p>
 * @author 門田明彦
 * @version $Revision: 1.2 $
 */
public class BeanQLPreparedStatementTest extends TestCase {

  BeanQLManager bm;
  
  /**
   * Constructor for BeanQLPreparedStatementTest.
   * @param arg0
   */
  public BeanQLPreparedStatementTest(String arg0) {
    super(arg0);
  }

  /*
   * @see TestCase#setUp()
   */
  protected void setUp() throws Exception {
    super.setUp();
    
    bm = BeanQLTestUtil_inJar.createBeanQLManager();
  }

  /*
   * @see TestCase#tearDown()
   */
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  public void testSelect() throws BeanQLException, SQLException {
    BeanQLTransaction bt = bm.getBeanQLTransaction();
    BeanQLPreparedStatement st = bt.createPreparedStatement(AmsTest.class, "select * from amsTest where name=?");
    String name = "testSelect" + System.currentTimeMillis();

    {    
      // insert dummy
      BeanQLStatement bs = bt.createStatement(AmsTest.class);
      name = name.substring(0, 20);
      AmsTest at = new ams.com.ams.beanql.test.bean.AmsTest();
      at.setNameID(bs.getNextSequence());
      at.setName(name);
      bs.insert(at);
    }
    
    {
      // select name = name
      st.setString(1, name);
      Collection col = st.select();
      BeanDebug.printCollection(col);
      if (col.size() == 0) {
        // 取得失敗
        fail("result size = 0");
      }
    }
    
    st.close();
    bt.close();
  }

  public void testSelectOne() throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
    BeanQLTransaction bt = bm.getBeanQLTransaction();
    BeanQLPreparedStatement st = bt.createPreparedStatement(AmsTest.class, "select * from amsTest where nameID=?");
    String name = "testSelectOne" + System.currentTimeMillis();

    AmsTest at = new ams.com.ams.beanql.test.bean.AmsTest();
    {    
      // insert dummy
      BeanQLStatement bs = bt.createStatement(AmsTest.class);
      name = name.substring(0, 20);
      at.setNameID(bs.getNextSequence());
      at.setName(name);
      bs.insert(at);
    }
    
    {
      // select id = ?
      st.setInt(1, at.getNameID());
      AmsTest atg = (AmsTest)st.selectOne();
      BeanDebug.print(atg);
    }
    
    st.close();
    bt.close();
  }

}
