/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.beanql;

import ams.com.ams.beanql.BeanProperty;
import ams.com.ams.beanql.BeanQLStatementIF;
import ams.com.ams.beanql.BeanQLStatementSupport;
import ams.com.ams.beanql.BeanQLTransaction;
import ams.com.ams.beanql.ColumnProperty;
import ams.com.ams.beanql.exceptions.BeanQLException;
import ams.com.ams.beanql.exceptions.BeanQLResultEmptyException;
import ams.com.ams.beanql.exceptions.BeanQLResultMultiException;
import ams.com.ams.beanql.exceptions.BeanQLTableNotFoundException;
import ams.com.ams.beanql.vendor.DBDependQLStatement;
import ams.com.ams.beanql.vendor.DBDependQLStatementFactory;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BeanQLStatement
extends BeanQLStatementSupport {
    private Statement statement;

    BeanQLStatement(Class bean_class, Statement statement, BeanQLTransaction super_tr) throws BeanQLException, BeanQLTableNotFoundException {
        this.bean = bean_class;
        this.statement = statement;
        this.super_tr = super_tr;
        int last_dot = this.bean.getName().lastIndexOf(46);
        this.tableName = last_dot == -1 ? this.bean.getName() : this.bean.getName().substring(last_dot + 1);
        try {
            this.createSQLMapping();
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public Collection selectAll() throws BeanQLException, SQLException {
        StringBuffer sql = new StringBuffer("SELECT * FROM " + this.getTableName());
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.statement.executeQuery(sql.toString());
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public Collection select(String where) throws SQLException, BeanQLException {
        return this.select(where, "", "");
    }

    public Collection select(String where, String groupby) throws SQLException, BeanQLException {
        return this.select(where, groupby, "");
    }

    public Collection select(String where, String groupby, String orderby) throws SQLException, BeanQLException {
        DBDependQLStatement dqs = DBDependQLStatementFactory.create(this.statement.getConnection(), this.super_tr.mgr);
        String sql = dqs.getSelectSQL(this.getTableName(), this.bpList, where, groupby, orderby);
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.statement.executeQuery(sql);
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public void insert(Object o) throws BeanQLException, SQLException {
        this.validateBean(o);
        StringBuffer sql = new StringBuffer("INSERT INTO " + this.getTableName() + " values(");
        int c = 0;
        Iterator bpit = ((AbstractList)this.bpList).iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            Object val = this.getValueByType(o, bp);
            if (c > 0) {
                sql.append(",");
            }
            sql.append(this.formatVal(val));
            ++c;
        }
        if (c == 0) {
            throw new BeanQLException("don't get Column");
        }
        sql.append(")");
        this.statement.executeUpdate(sql.toString());
    }

    private void validateBean(Object o) throws BeanQLException {
        if (o == null) {
            throw new BeanQLException("object is null.");
        }
        if (o.getClass() != this.bean) {
            throw new BeanQLException("object is not instanceof " + this.bean);
        }
    }

    public int delete(Object o) throws BeanQLException, SQLException {
        this.validateBean(o);
        StringBuffer sql = new StringBuffer("DELETE FROM " + this.getTableName() + " WHERE ");
        String where = null;
        Iterator bpit = ((AbstractList)this.bpList).iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            Object val = this.getValueByType(o, bp);
            where = String.valueOf(bp.getName()) + " = " + this.formatVal(val);
            break;
        }
        if (where == null) {
            throw new BeanQLException("cannot get Primary Key Column of :" + this.tableName);
        }
        sql.append(where);
        return this.statement.executeUpdate(sql.toString());
    }

    public int delete(String where) throws BeanQLException, SQLException {
        StringBuffer sql = new StringBuffer("DELETE FROM " + this.getTableName() + " WHERE " + where);
        if (where == null || where.trim().length() == 0) {
            throw new BeanQLException("where statement is empty");
        }
        return this.statement.executeUpdate(sql.toString());
    }

    public int update(Object o) throws BeanQLException, SQLException {
        return this.update(o, "");
    }

    public int update(Object o, String where) throws BeanQLException, SQLException {
        this.validateBean(o);
        StringBuffer sql = new StringBuffer("UPDATE " + this.getTableName() + " SET ");
        int c = 0;
        Iterator bpit = ((AbstractList)this.bpList).iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (bp.getColumnProp().isPrimaryKey()) continue;
            Object val = this.getValueByType(o, bp);
            if (c > 0) {
                sql.append(",");
            }
            sql.append(String.valueOf(bp.getName()) + "=" + this.formatVal(val));
            ++c;
        }
        if (c == 0) {
            throw new BeanQLException("don't get Column");
        }
        sql.append(" WHERE ");
        int pc = 0;
        Iterator bpit2 = ((AbstractList)this.bpList).iterator();
        while (bpit2.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit2.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            if (pc > 0) {
                sql.append(",");
            }
            Object val = this.getValueByType(o, bp);
            sql.append(String.valueOf(bp.getName()) + " = " + this.formatVal(val));
        }
        if (where != null && where.trim().length() > 0) {
            sql.append(" AND " + where.trim());
        }
        return this.statement.executeUpdate(sql.toString());
    }

    private Object getValueByType(Object o, BeanProperty bp) throws BeanQLException {
        Method method = bp.getM_get();
        if (method == null) {
            throw new BeanQLException("not implement type:" + bp.getName());
        }
        try {
            return method.invoke(o, null);
        }
        catch (Exception e) {
            throw new BeanQLException(e.getMessage(), e);
        }
    }

    public int getNextSequence() throws BeanQLException {
        try {
            Class<?> clazz = this.bean.getClass();
            synchronized (clazz) {
                StringBuffer sql_select = new StringBuffer(" SELECT sequence " + this.super_tr.mgr.getSequenceTable() + " FROM " + this.super_tr.mgr.getSequenceTable() + " WHERE tableName = '" + this.getTableName() + "'");
                ColumnProperty cp = (ColumnProperty)this.getColumnPropertyList().get(0);
                StringBuffer sql_select_max = new StringBuffer(" SELECT MAX(" + cp.getName() + ")" + " FROM " + this.getTableName());
                int check_c = 0;
                int now_seq = 0;
                int table_max_seq = 0;
                ResultSet result_c = this.statement.executeQuery(sql_select.toString());
                if (result_c.next()) {
                    ++check_c;
                    now_seq = result_c.getInt(1);
                }
                result_c.close();
                ResultSet result = this.statement.executeQuery(sql_select_max.toString());
                if (result.next()) {
                    table_max_seq = result.getInt(1);
                }
                result.close();
                if (check_c == 0) {
                    now_seq = table_max_seq;
                    if (check_c == 0) {
                        StringBuffer sql_insert = new StringBuffer("INSERT INTO " + this.super_tr.mgr.getSequenceTable() + " VALUES('" + this.getTableName() + "'," + now_seq + ")");
                        this.statement.executeUpdate(sql_insert.toString());
                    }
                } else {
                    now_seq = now_seq > table_max_seq ? now_seq : table_max_seq;
                }
                boolean is_auto_commit = this.super_tr.getConnection().getAutoCommit();
                this.super_tr.setAutoCommit(false);
                StringBuffer sql_update = new StringBuffer(" UPDATE " + this.super_tr.mgr.getSequenceTable() + " SET sequence = " + (now_seq + 1) + " WHERE tableName = '" + this.getTableName() + "'");
                int c = this.statement.executeUpdate(sql_update.toString());
                if (c == 0) {
                    throw new BeanQLException("cannot update sequence");
                }
                ResultSet result2 = this.statement.executeQuery(sql_select.toString());
                int sequence_val = 0;
                if (result2.next()) {
                    sequence_val = result2.getInt(1);
                }
                result2.close();
                this.super_tr.commit();
                this.super_tr.setAutoCommit(is_auto_commit);
                return sequence_val;
            }
        }
        catch (SQLException e) {
            this.super_tr.rollback();
            e.printStackTrace();
            throw new BeanQLException(e);
        }
    }

    public Object selectOne(String where) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        return this.selectOne(where, "");
    }

    public Object selectOne(String where, String order_by) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Collection col = this.select(where, order_by);
        if (col.isEmpty()) {
            throw new BeanQLResultEmptyException("\u691c\u7d22\u7d50\u679c 0\u4ef6");
        }
        if (col.size() > 1) {
            throw new BeanQLResultMultiException("\u691c\u7d22\u7d50\u679c " + col.size() + "\u4ef6");
        }
        Object o = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public void close() throws BeanQLException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                throw new BeanQLException(e);
            }
        }
    }

    public static void closeSafe(BeanQLStatementIF st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (BeanQLException e) {
            e.printStackTrace();
        }
    }
}

