package jp.co.powerbeans.powerql.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.exceptions.POQLException;


/**
 * <p>タイトル: DBDependQLStatementFactory</p>
 * <p>説明: DBDependQLStatement実装クラスのFactoryクラス。</p>
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/10</p>
 * @author 門田明彦
 * @version $Revision: 1.4 $
 */
public class DBDependQLStatementFactory {

    private static final Map depCache = new HashMap();
    
	/**
	 * 
	 */
	private DBDependQLStatementFactory() {
		super();
	}

	/**
	 * create<BR>
	 * DBDependQLStatement 実装クラスを作成して返す
	 * @param connection
	 * @param manager
	 * @return DBDependQLStatement 実装クラス
	 */
	public static final DBDependQLStatement create(Connection connection, POQLManager manager)
	throws POQLException {
		
		Class[] impls = {
			null, // def
			DBDependQLStatementOracle.class,
			DBDependQLStatementMySQL.class,
			DBDependQLStatementDB2.class,
			DBDependQLStatementPGSQL.class,
      DBDependQLStatementHSQL.class
		};
		
		int type = manager.getVendorType();
		if (type < 0 || type >= impls.length ||
			impls[type] == null) {
			throw new POQLException("vendor type is invalid:" + type);
		}
		try {
		    DBDependQLStatement st = null; 
            // 毎回インスタンスかしないでキャッシュする
		    if (!depCache.containsKey(impls[type])) {
		        st = (DBDependQLStatement)impls[type].newInstance();
		        depCache.put(impls[type], st);
		    } else {
		        st = (DBDependQLStatement) depCache.get(impls[type]);
		    }
			st.setConnection(connection);
			st.setManager(manager);
			st.setStatement(connection.createStatement());
			
			return st;
		} catch (InstantiationException e) {
			throw new POQLException(e);
		} catch (IllegalAccessException e) {
			throw new POQLException(e);
		} catch (SQLException e) {
		    throw new POQLException(e);
        }
	}

}
