package jp.co.powerbeans.powerql.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLPreparedStatement;
import jp.co.powerbeans.powerql.exceptions.POQLException;


/**
 * <p>タイトル: DBDependQLStatement</p>
 * <p>説明: ベンダーごとに異なるSQLを処理する汎用クラスのインターフェイス</p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/10</p>
 * @author 門田明彦
 * @version $Revision: 1.6 $
 */
public interface DBDependQLStatement {

	/**
	 * getColumnPropertyList<BR>
	 * テーブルのカラムプロパティを作成
	 * @param table テーブル名
	 * @param schema TODO
	 * @return ColumnProperty のリスト
	 */
	ArrayList getColumnPropertyList(String table, String schema) throws SQLException, POQLException;

	/**
	 * setConnection<BR>
	 * コネクションを設定
	 * @param connection
	 */
	void setConnection(Connection connection);

	/**
	 * setManager<BR>
	 * POQLManager を設定
	 * @param manager
	 */
	void setManager(POQLManager manager);

	/**
	 * setStatement<BR>
	 * Statement を設定
	 * @param statement
	 */
	void setStatement(Statement statement);

	/**
	 * isExistTable<BR>
	 * テーブルが存在するかどうか取得
	 * @param table_name テーブル名
	 * @return true:存在, false:存在しない
	 */
	boolean isExistTable(String table_name) throws SQLException ;

	/**
	 * createTable<BR>
	 * テーブルを新規作成
	 * @param table_name テーブル名
	 * @param cp カラムプロパティ配列
	 */
	void createTable(String table_name, ColumnProperty[] cp) throws  POQLException, SQLException ;

  /**
   * getSelectSQL<BR>
   * パラメータの条件からSQLを作成。
   * フィールドはできるだけ取得する。
   * @param table_name テーブル名
   * @param bpList BeanPropertyList
   * @param where where句
   * @param groupby groupby句
   * @param orderby orderby句
   * @return select SQL
   */
  String getSelectSQL(String table_name, ArrayList bpList, String where, String groupby, String orderby);

	/**
	 * 現在日付を表すSQL関数を取得
	 * @return 現在日付を表すSQL関数
	 */
	String getSQL_NOW();

	/**
	 * フィールドタイプを指定して現在日付を表すSQL関数を取得
	 * @param column_type フィールドタイプ(DATE or TIMESTAMP or TIME)
	 * @return 現在日付を表すSQL関数
	 */
	String getSQL_NOW(String column_type);
//
//    /**
//     * ベンダー実装Blobクラスを返す
//     * @return Blobクラス。実装していない場合は null
//     */
//    Class getBlobClass();

    /**
     * Date型をDBフィールドタイプにあわせてフォーマットした文字列を
     * 返す
     * @param date 日付データ
     * @param column_type DBフィールドタイプ(DATE,DATETIME,TIMESTAMP)
     * @return フォーマットした日付時間文字列
     */
    String formatDateVal(Date date, String column_type);

	/**
	 * 全スキーマの全テーブルを取得するSQLを返す
	 * @return 全テーブル取得SQL(必須カラム tableName, 英字順)
	 */
	String getSysSelectTableAllSql();

	/**
	 * schemaの全テーブルを取得するSQLを返す
	 * @return schema全テーブル取得SQL(必須カラム tableName, 英字順)
	 */
	String getSysSelectTableBySchemaSql(String schema);
	
	/**
	 * 取得可能な全スキーマを取得するSQLを返す
	 * @return 全スキーマ取得SQL (必須カラム schemaName)
	 */
	String getSysSelectSchemaAllSql();

	/**
	 * sql 内の DBMS予約語をエスケープして返す
	 * @param sql エスケープ対象文字列
	 * @return　エスケープ後文字列
	 */
	String escape(String sql);

	/**
	 * 最後にINSERTしたレコードのPK1カラムの値(ID)を取得.<BR>
	 * MySQL:AUTO INCREMENT された値.<BR>
	 * Oracle:ROWIDが一致するレコードのPK値.<BR>
	 * <BR>
	 * サポートしていない場合はログを出力し 0 を返す
	 * @param st 
	 * @return
	 * @throws SQLException 
	 */
	Object getGeneratedKey(POQLPreparedStatement st) throws SQLException;

////	/**
////	 * createTable<BR>現時点では実装なし
////	 * @param string
////	 * @param properties
////	 */
////	void createTable(String string, BeanProperty[] properties)  throws SQLException;

//	/**
//	 * getMultiTypeVal<BR>
//	 * 結果セットとカラム名を指定してオブジェクトの値をJAVAの値として取得<BR>
//	 * 共通）<BR>
//	 * DB                JAVA
//	 * int       >       Integer
//	 * VARCHAR(x) >      String
//	 * 
//	 * @param result 検索結果
//	 * @param column カラム名
//	 * @return 値
//	 */	
//	Object getMultiTypeVal(ResultSet result, String column);
}
