package jp.co.powerbeans.powerql.dao;

import java.util.ArrayList;
import java.util.Collection;

import jp.co.powerbeans.powerql.POQLManager;
import jp.co.powerbeans.powerql.POQLTransaction;
import jp.co.powerbeans.powerql.POQLViewPreparedStatement;

/**
 * POQLDynaViewDAO基本実装クラス。
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * @author A.Monden
 */
public class POQLStandardDynaViewDAO extends POQLDynaViewBaseDAO {

    /**
     * コンストラクタ
     * @param manager マネージャ
     * @param c 検索結果格納JavaBean
     * @param table_beans 結合テーブル型
     * @param join_sql 結合SQL
     */
    public POQLStandardDynaViewDAO(POQLManager manager, Class c, Class[] table_beans, String join_sql) {
        super(manager,c,table_beans, join_sql);
    }


    /**
     * コンストラクタ
     * @param manager マネージャ
     * @param c 検索結果格納JavaBean
     * @param sql 検索SQL
     */
    public POQLStandardDynaViewDAO(POQLManager manager, Class c, String sql) {
        super(manager, c, sql);
    }


    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findBy(java.lang.String)
     */
    public Collection findBy(String where) {
        
        return findBy(where, "");
    }

    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findBy(java.lang.String, java.lang.String)
     */
    public Collection findBy(String where, String order_by) {
        
        POQLTransaction bqlTrn = null;
        try {
            bqlTrn = getPowerQLTransaction();
            StringBuffer sql = new StringBuffer(getDviewSql());
            
            if (where != null && where.trim().length() > 0) {
                if (getJoinSql().trim().length() == 0) {
                    sql.append(" WHERE ");
                } else {
                    sql.append(" AND ");
                }
                sql.append(" " + where);
            }
            if (order_by != null && order_by.trim().length() > 0) {
                sql.append(" ORDER BY " + order_by);
            }
            POQLViewPreparedStatement st = bqlTrn.createViewPreparedStatement(
                    getBeanClass(), sql.toString());
            
            return st.select();

        } catch (Exception e) {
            onException(e);
        } finally {
            close(bqlTrn);
        }

        return new ArrayList();
    }

    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#find1By(java.lang.String, java.lang.String)
     */
    public Object find1By(String where) {
        return find1By(where, "");
    }

    /* (Javadoc なし)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#find1By(java.lang.String)
     */
    public Object find1By(String where, String order_by) {
        POQLTransaction bqlTrn = null;
        Object bean = null;
        try {
            bqlTrn = getPowerQLTransaction();
            StringBuffer sql = new StringBuffer(getDviewSql());
            
            if (where != null && where.trim().length() > 0) {
                if (getJoinSql().trim().length() == 0) {
                    sql.append(" WHERE ");
                } else {
                    sql.append(" AND ");
                }
                sql.append(" " + where);
            }
            if (order_by != null && order_by.trim().length() > 0) {
                sql.append(" ORDER BY " + order_by);
            }
            POQLViewPreparedStatement st = bqlTrn.createViewPreparedStatement(
                    getBeanClass(), sql.toString());
            bean = st.selectOne();

        } catch (Exception e) {
            onException(e);
        } finally {
            close(bqlTrn);
        }

        if (bean == null) {
            bean = createSafeBean();
        }
        return bean;
    }


    /* (non-Javadoc)
     * @see jp.co.powerbeans.powerql.dao.POQLDynaViewDAO#findByAll()
     */
    public Collection findByAll() {
        
        return findBy(null);
    }
    
}
